/*
 * Decompiled with CFR 0.152.
 */
package suszombification.block.entity;

import com.mojang.datafixers.util.Unit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import suszombification.block.TrophyBlock;
import suszombification.registration.SZBlockEntityTypes;
import suszombification.registration.SZDataComponents;

public class TrophyBlockEntity
extends BlockEntity {
    private TrophyBlock.TrophyType trophyType;
    private boolean curseGiven;

    public TrophyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SZBlockEntityTypes.TROPHY.get(), pos, state);
    }

    public TrophyBlockEntity(BlockEntityType<? extends TrophyBlockEntity> blockEntityType, BlockPos pos, BlockState state, TrophyBlock.TrophyType trophyType) {
        super(blockEntityType, pos, state);
        this.trophyType = trophyType;
    }

    public void setCurseGiven(boolean curseGiven) {
        this.curseGiven = curseGiven;
    }

    public boolean isCurseGiven() {
        return this.curseGiven;
    }

    public TrophyBlock.TrophyType getTrophyType() {
        return this.trophyType;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        tag.putInt("TrophyType", this.trophyType.ordinal());
        tag.putBoolean("CurseGiven", this.curseGiven);
        super.saveAdditional(tag, lookupProvider);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        int savedOrdinal = tag.getInt("TrophyType");
        this.trophyType = savedOrdinal < 0 || savedOrdinal >= TrophyBlock.TrophyType.values().length ? TrophyBlock.TrophyType.CARROT : TrophyBlock.TrophyType.values()[savedOrdinal];
        this.curseGiven = tag.getBoolean("CurseGiven");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveCustomOnly(lookupProvider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        this.curseGiven = componentInput.get(SZDataComponents.CURSE_GIVEN) != null;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        if (this.curseGiven) {
            components.set(SZDataComponents.CURSE_GIVEN, (Object)Unit.INSTANCE);
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CurseGiven");
    }
}

