/*
 * Decompiled with CFR 0.152.
 */
package suszombification.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import suszombification.registration.SZEffects;

public class AmplifyingEffect
extends MobEffect {
    public AmplifyingEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        for (MobEffectInstance effect : entity.getActiveEffects()) {
            if (effect.getEffect().value() == SZEffects.AMPLIFYING.get() || effect.amplifier > 63) continue;
            effect.update(new MobEffectInstance(effect.getEffect(), effect.getDuration(), (effect.amplifier + 1) * (amplifier + 2) - 1));
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration == 1;
    }

    public boolean isInstantenous() {
        return true;
    }
}

