/*
 * Decompiled with CFR 0.152.
 */
package suszombification.effect;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.event.EventHooks;
import suszombification.SZDamageSources;
import suszombification.entity.ZombifiedAnimal;
import suszombification.registration.SZLoot;

public class DecomposingEffect
extends MobEffect {
    public DecomposingEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide) {
            if (entity instanceof Animal) {
                Animal animal = (Animal)entity;
                EntityType<? extends Animal> conversionType = ZombifiedAnimal.VANILLA_TO_ZOMBIFIED.get(animal.getType());
                if (conversionType != null && EventHooks.canLivingConvert((LivingEntity)animal, conversionType, timer -> {})) {
                    Mob convertedAnimal = animal.convertTo(conversionType, false);
                    if (convertedAnimal != null) {
                        EventHooks.finalizeMobSpawn((Mob)convertedAnimal, (ServerLevelAccessor)((ServerLevel)animal.level()), (DifficultyInstance)animal.level().getCurrentDifficultyAt(convertedAnimal.blockPosition()), (MobSpawnType)MobSpawnType.CONVERSION, null);
                        ((ZombifiedAnimal)convertedAnimal).readFromVanilla(animal);
                        EventHooks.onLivingConvert((LivingEntity)animal, (LivingEntity)convertedAnimal);
                        if (!animal.isSilent()) {
                            animal.level().levelEvent(null, 1026, animal.blockPosition(), 0);
                        }
                    }
                } else {
                    entity.hurt(SZDamageSources.decomposing(entity.level().registryAccess()), Float.MAX_VALUE);
                    if (entity.isDeadOrDying()) {
                        this.spawnDecomposingDrops(entity);
                    }
                }
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.getAbilities().instabuild) {
                    entity.hurt(SZDamageSources.decomposing(entity.level().registryAccess()), Float.MAX_VALUE);
                    this.spawnDecomposingDrops(entity);
                }
            }
        }
        return true;
    }

    private void spawnDecomposingDrops(LivingEntity entity) {
        LootTable lootTable = entity.level().getServer().reloadableRegistries().getLootTable(SZLoot.DEATH_BY_DECOMPOSING);
        LootParams lootParams = new LootParams.Builder((ServerLevel)entity.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withOptionalParameter(LootContextParams.DAMAGE_SOURCE, (Object)SZDamageSources.decomposing(entity.level().registryAccess())).create(LootContextParamSets.ENTITY);
        lootTable.getRandomItems(lootParams).forEach(arg_0 -> ((LivingEntity)entity).spawnAtLocation(arg_0));
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration == 1;
    }

    public DecomposingEffect addAttributeModifier(Holder<Attribute> attribute, ResourceLocation id, double value, AttributeModifier.Operation operation) {
        super.addAttributeModifier(attribute, id, value, operation);
        return this;
    }
}

