/*
 * Decompiled with CFR 0.152.
 */
package suszombification.effect;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class VicinityAffectingEffect
extends MobEffect {
    private final UnaryOperator<Integer> areaSize;
    private final Predicate<LivingEntity> filter;
    private final Supplier<MobEffectInstance>[] effects;

    @SafeVarargs
    public VicinityAffectingEffect(MobEffectCategory category, int color, UnaryOperator<Integer> areaSize, Predicate<LivingEntity> filter, Supplier<MobEffectInstance> ... effects) {
        super(category, color);
        this.areaSize = areaSize;
        this.filter = filter;
        this.effects = effects;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        List nearbyEntities = entity.level().getEntities((Entity)entity, entity.getBoundingBox().inflate((double)((Integer)this.areaSize.apply(amplifier)).intValue()), e -> {
            LivingEntity target;
            return e instanceof LivingEntity && this.filter.test(target = (LivingEntity)e);
        });
        for (Entity nearbyEntity : nearbyEntities) {
            LivingEntity nearby = (LivingEntity)nearbyEntity;
            for (Supplier<MobEffectInstance> effect : this.effects) {
                nearby.addEffect(effect.get());
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 5 == 0;
    }
}

