/*
 * Decompiled with CFR 0.152.
 */
package suszombification.entity;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import suszombification.registration.SZEntityTypes;
import suszombification.registration.SZItems;

public class ThrownRottenEgg
extends ThrowableItemProjectile {
    public ThrownRottenEgg(EntityType<? extends ThrownRottenEgg> type, Level level) {
        super(type, level);
    }

    public ThrownRottenEgg(Level level, LivingEntity owner) {
        super((EntityType)SZEntityTypes.ROTTEN_EGG.get(), owner, level);
    }

    public ThrownRottenEgg(Level level, double x, double y, double z) {
        super((EntityType)SZEntityTypes.ROTTEN_EGG.get(), x, y, z, level);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.random.nextInt(8) == 0) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200));
            }
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return (Item)SZItems.ROTTEN_EGG.get();
    }
}

