/*
 * Decompiled with CFR 0.152.
 */
package suszombification.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;

public interface ZombifiedAnimal {
    public static final Map<EntityType<?>, EntityType<? extends Animal>> VANILLA_TO_ZOMBIFIED = new HashMap();

    public EntityType<? extends Animal> getNormalVariant();

    default public void readFromVanilla(Animal animal) {
    }

    default public void writeToVanilla(Animal animal) {
    }

    public boolean isConverting();

    public void setConverting();

    public void setConversionTime(int var1);

    public int getConversionTime();

    default public void startConverting(int conversionTime) {
        Animal animal = (Animal)this;
        this.setConversionTime(conversionTime);
        this.setConverting();
        animal.removeEffect(MobEffects.WEAKNESS);
        animal.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, conversionTime, Math.min(animal.level().getDifficulty().getId() - 1, 0)));
        animal.level().broadcastEntityEvent((Entity)animal, (byte)16);
    }

    default public void finishConversion(ServerLevel level) {
        Animal zombifiedAnimal = (Animal)this;
        Animal vanillaAnimal = (Animal)zombifiedAnimal.convertTo(this.getNormalVariant(), false);
        if (vanillaAnimal != null) {
            EventHooks.finalizeMobSpawn((Mob)vanillaAnimal, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(vanillaAnimal.blockPosition()), (MobSpawnType)MobSpawnType.CONVERSION, null);
            this.writeToVanilla(vanillaAnimal);
            vanillaAnimal.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
            if (!zombifiedAnimal.isSilent()) {
                level.levelEvent(null, 1027, zombifiedAnimal.blockPosition(), 0);
            }
            EventHooks.onLivingConvert((LivingEntity)zombifiedAnimal, (LivingEntity)vanillaAnimal);
        }
    }

    default public int getConversionProgress() {
        int progress = 1;
        Animal animal = (Animal)this;
        if (animal.getRandom().nextFloat() < 0.01f) {
            int buffCount = 0;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int x = (int)animal.getX() - 4;
            while ((double)x < animal.getX() + 4.0 && buffCount < 14) {
                int y = (int)animal.getY() - 4;
                while ((double)y < animal.getY() + 4.0 && buffCount < 14) {
                    int z = (int)animal.getZ() - 4;
                    while ((double)z < animal.getZ() + 4.0 && buffCount < 14) {
                        BlockState state = animal.level().getBlockState((BlockPos)pos.set(x, y, z));
                        if (state.is(BlockTags.WOODEN_FENCES) || state.is(Blocks.HAY_BLOCK)) {
                            if (animal.getRandom().nextFloat() < 0.3f) {
                                ++progress;
                            }
                            ++buffCount;
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return progress;
    }
}

