/*
 * Decompiled with CFR 0.152.
 */
package suszombification.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.CatLieOnBedGoal;
import net.minecraft.world.entity.ai.goal.CatSitOnBlockGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import suszombification.entity.ZombifiedAnimal;
import suszombification.entity.ai.NearestNormalVariantTargetGoal;
import suszombification.entity.ai.SPPTemptGoal;
import suszombification.misc.AnimalUtil;
import suszombification.registration.SZEntityTypes;
import suszombification.registration.SZLoot;

public class ZombifiedCat
extends Cat
implements NeutralMob,
ZombifiedAnimal {
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING});
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(ZombifiedCat.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;
    private int conversionTime;

    public ZombifiedCat(EntityType<? extends Cat> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new ZombifiedCatRelaxOnOwnerGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ZombifiedCatTemptGoal(this, 0.6, TEMPT_INGREDIENT, true));
        this.goalSelector.addGoal(5, (Goal)new CatLieOnBedGoal((Cat)this, 1.1, 8));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f));
        this.goalSelector.addGoal(7, (Goal)new CatSitOnBlockGoal((Cat)this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new OcelotAttackGoal((Mob)this));
        this.goalSelector.addGoal(10, (Goal)new BreedGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8, 1.0000001E-5f));
        this.goalSelector.addGoal(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Rabbit.class, false, null));
        this.targetSelector.addGoal(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(2, (Goal)new NearestNormalVariantTargetGoal(this, true, false, animal -> !((Cat)animal).isTame()));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CONVERTING_ID, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    public void tick() {
        AnimalUtil.tick((LivingEntity)this);
        super.tick();
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult returnValue = AnimalUtil.mobInteract((LivingEntity)this, player, hand);
        if (returnValue != InteractionResult.PASS) {
            return returnValue;
        }
        return super.mobInteract(player, hand);
    }

    public void handleEntityEvent(byte id) {
        if (!AnimalUtil.handleEntityEvent((LivingEntity)this, id)) {
            super.handleEntityEvent(id);
        }
    }

    public Cat getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (Cat)((EntityType)SZEntityTypes.ZOMBIFIED_CAT.get()).create((Level)level);
    }

    public boolean isFood(ItemStack stack) {
        return AnimalUtil.isFood(stack, TEMPT_INGREDIENT);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("ConversionTime", 99) && tag.getInt("ConversionTime") > -1) {
            this.startConverting(tag.getInt("ConversionTime"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("ConversionTime", this.isConverting() ? this.conversionTime : -1);
    }

    protected void reassessTameGoals() {
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.persistentAngerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    public EntityType<? extends Animal> getNormalVariant() {
        return EntityType.CAT;
    }

    @Override
    public void readFromVanilla(Animal animal) {
        if (animal instanceof Cat) {
            Cat cat = (Cat)animal;
            this.setVariant(this.getVariant());
            this.setTame(cat.isTame(), true);
            this.setCollarColor(cat.getCollarColor());
            this.setOwnerUUID(cat.getOwnerUUID());
        }
    }

    @Override
    public void writeToVanilla(Animal animal) {
        if (animal instanceof Cat) {
            Cat cat = (Cat)animal;
            cat.setVariant(this.getVariant());
            cat.setTame(this.isTame(), true);
            cat.setCollarColor(this.getCollarColor());
            cat.setOwnerUUID(this.getOwnerUUID());
        }
    }

    @Override
    public boolean isConverting() {
        return (Boolean)this.getEntityData().get(DATA_CONVERTING_ID);
    }

    @Override
    public void setConverting() {
        this.getEntityData().set(DATA_CONVERTING_ID, (Object)true);
    }

    @Override
    public void setConversionTime(int conversionTime) {
        this.conversionTime = conversionTime;
    }

    @Override
    public int getConversionTime() {
        return this.conversionTime;
    }

    static class ZombifiedCatRelaxOnOwnerGoal
    extends Cat.CatRelaxOnOwnerGoal {
        public ZombifiedCatRelaxOnOwnerGoal(Cat cat) {
            super(cat);
        }

        public void giveMorningGift() {
            RandomSource random = this.cat.getRandom();
            BlockPos.MutableBlockPos catPos = new BlockPos.MutableBlockPos();
            LootTable lootTable = this.cat.level().getServer().reloadableRegistries().getLootTable(SZLoot.ZOMBIFIED_CAT_MORNING_GIFT);
            LootParams lootParams = new LootParams.Builder((ServerLevel)this.cat.level()).withParameter(LootContextParams.ORIGIN, (Object)this.cat.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this.cat).create(LootContextParamSets.GIFT);
            catPos.set((Vec3i)this.cat.blockPosition());
            this.cat.randomTeleport((double)(catPos.getX() + random.nextInt(11) - 5), (double)(catPos.getY() + random.nextInt(5) - 2), (double)(catPos.getZ() + random.nextInt(11) - 5), false);
            catPos.set((Vec3i)this.cat.blockPosition());
            for (ItemStack stack : lootTable.getRandomItems(lootParams)) {
                this.cat.level().addFreshEntity((Entity)new ItemEntity(this.cat.level(), (double)catPos.getX() - (double)Mth.sin((float)(this.cat.yBodyRot * ((float)Math.PI / 180))), (double)catPos.getY(), (double)catPos.getZ() + (double)Mth.cos((float)(this.cat.yBodyRot * ((float)Math.PI / 180))), stack));
            }
        }
    }

    static class ZombifiedCatTemptGoal
    extends SPPTemptGoal {
        private Player selectedPlayer;
        private final ZombifiedCat cat;

        public ZombifiedCatTemptGoal(ZombifiedCat mob, double speedModifier, Ingredient items, boolean canScare) {
            super((PathfinderMob)mob, speedModifier, items, canScare);
            this.cat = mob;
        }

        public void tick() {
            super.tick();
            if (this.selectedPlayer == null && this.mob.getRandom().nextInt(600) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.mob.getRandom().nextInt(500) == 0) {
                this.selectedPlayer = null;
            }
        }

        protected boolean canScare() {
            return (this.selectedPlayer == null || !this.selectedPlayer.equals((Object)this.player)) && super.canScare();
        }

        public boolean canUse() {
            return super.canUse() && !this.cat.isTame();
        }
    }
}

