/*
 * Decompiled with CFR 0.152.
 */
package suszombification.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import suszombification.entity.ZombifiedAnimal;
import suszombification.entity.ai.NearestNormalVariantTargetGoal;
import suszombification.entity.ai.SPPTemptGoal;
import suszombification.misc.AnimalUtil;
import suszombification.registration.SZEntityTypes;
import suszombification.registration.SZItems;

public class ZombifiedChicken
extends Animal
implements NeutralMob,
ZombifiedAnimal {
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.CHICKEN.getDimensions().scale(0.5f).withEyeHeight(0.2975f);
    private static final Ingredient FOOD_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.CHICKEN, Items.FEATHER});
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(ZombifiedChicken.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int conversionTime;
    private float flap;
    private float flapSpeed;
    private float previousFlapSpeed;
    private float previousFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;
    private int eggTime = this.random.nextInt(6000) + 6000;
    private boolean isChickenJockey;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public ZombifiedChicken(EntityType<? extends ZombifiedChicken> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CONVERTING_ID, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new SPPTemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestNormalVariantTargetGoal(this, true, false));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(pose);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    public void tick() {
        AnimalUtil.tick((LivingEntity)this);
        super.tick();
    }

    public void aiStep() {
        super.aiStep();
        this.previousFlap = this.flap;
        this.previousFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.onGround() ? -1 : 4) * 0.3);
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 deltaMovement = this.getDeltaMovement();
        if (!this.onGround() && deltaMovement.y < 0.0) {
            this.setDeltaMovement(deltaMovement.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        if (!this.level().isClientSide && this.isAlive() && !this.isBaby() && !this.isChickenJockey() && --this.eggTime <= 0) {
            this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.spawnAtLocation((ItemLike)SZItems.ROTTEN_EGG.get());
            this.eggTime = this.random.nextInt(6000) + 6000;
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult returnValue = AnimalUtil.mobInteract((LivingEntity)this, player, hand);
        if (returnValue != InteractionResult.PASS) {
            return returnValue;
        }
        return super.mobInteract(player, hand);
    }

    public void handleEntityEvent(byte id) {
        if (!AnimalUtil.handleEntityEvent((LivingEntity)this, id)) {
            super.handleEntityEvent(id);
        }
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    protected void onFlap() {
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    public boolean causeFallDamage(float height, float mult, DamageSource source) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.CHICKEN_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.CHICKEN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.CHICKEN_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        this.playSound(SoundEvents.CHICKEN_STEP, 0.15f, 1.0f);
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
    }

    public ZombifiedChicken getBreedOffspring(ServerLevel level, AgeableMob parent) {
        return (ZombifiedChicken)((EntityType)SZEntityTypes.ZOMBIFIED_CHICKEN.get()).create((Level)level);
    }

    public int getBaseExperienceReward() {
        return (this.isChickenJockey() ? 10 : super.getBaseExperienceReward()) + 5;
    }

    public boolean isFood(ItemStack stack) {
        return AnimalUtil.isFood(stack, FOOD_ITEMS);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.isChickenJockey = tag.getBoolean("IsChickenJockey");
        if (tag.contains("EggLayTime")) {
            this.eggTime = tag.getInt("EggLayTime");
        }
        if (tag.contains("ConversionTime", 99) && tag.getInt("ConversionTime") > -1) {
            this.startConverting(tag.getInt("ConversionTime"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("IsChickenJockey", this.isChickenJockey);
        tag.putInt("EggLayTime", this.eggTime);
        tag.putInt("ConversionTime", this.isConverting() ? this.conversionTime : -1);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return this.isChickenJockey();
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        super.positionRider(passenger);
        if (passenger instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)passenger;
            entity.yBodyRot = this.yBodyRot;
        }
    }

    public boolean isChickenJockey() {
        return this.isChickenJockey;
    }

    public void setChickenJockey(boolean jockey) {
        this.isChickenJockey = jockey;
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.persistentAngerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    public EntityType<? extends Animal> getNormalVariant() {
        return EntityType.CHICKEN;
    }

    @Override
    public void readFromVanilla(Animal animal) {
        if (animal instanceof Chicken) {
            Chicken chicken = (Chicken)animal;
            this.setChickenJockey(chicken.isChickenJockey());
        }
    }

    @Override
    public void writeToVanilla(Animal animal) {
        if (animal instanceof Chicken) {
            Chicken chicken = (Chicken)animal;
            chicken.setChickenJockey(this.isChickenJockey());
        }
    }

    @Override
    public boolean isConverting() {
        return (Boolean)this.getEntityData().get(DATA_CONVERTING_ID);
    }

    @Override
    public void setConverting() {
        this.getEntityData().set(DATA_CONVERTING_ID, (Object)true);
    }

    @Override
    public void setConversionTime(int conversionTime) {
        this.conversionTime = conversionTime;
    }

    @Override
    public int getConversionTime() {
        return this.conversionTime;
    }

    public float getPreviousFlap() {
        return this.previousFlap;
    }

    public float getPreviousFlapSpeed() {
        return this.previousFlapSpeed;
    }

    public float getFlap() {
        return this.flap;
    }

    public float getFlapSpeed() {
        return this.flapSpeed;
    }
}

