/*
 * Decompiled with CFR 0.152.
 */
package suszombification.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import suszombification.entity.ZombifiedAnimal;
import suszombification.entity.ai.NearestNormalVariantTargetGoal;
import suszombification.entity.ai.SPPTemptGoal;
import suszombification.misc.AnimalUtil;
import suszombification.registration.SZBlocks;
import suszombification.registration.SZEntityTypes;
import suszombification.registration.SZLoot;

public class ZombifiedSheep
extends Sheep
implements NeutralMob,
ZombifiedAnimal {
    private static final Map<DyeColor, ItemLike> ITEM_BY_DYE = (Map)Util.make((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, (ItemLike)SZBlocks.WHITE_ROTTEN_WOOL.get());
        map.put(DyeColor.ORANGE, (ItemLike)SZBlocks.ORANGE_ROTTEN_WOOL.get());
        map.put(DyeColor.MAGENTA, (ItemLike)SZBlocks.MAGENTA_ROTTEN_WOOL.get());
        map.put(DyeColor.LIGHT_BLUE, (ItemLike)SZBlocks.LIGHT_BLUE_ROTTEN_WOOL.get());
        map.put(DyeColor.YELLOW, (ItemLike)SZBlocks.YELLOW_ROTTEN_WOOL.get());
        map.put(DyeColor.LIME, (ItemLike)SZBlocks.LIME_ROTTEN_WOOL.get());
        map.put(DyeColor.PINK, (ItemLike)SZBlocks.PINK_ROTTEN_WOOL.get());
        map.put(DyeColor.GRAY, (ItemLike)SZBlocks.GRAY_ROTTEN_WOOL.get());
        map.put(DyeColor.LIGHT_GRAY, (ItemLike)SZBlocks.LIGHT_GRAY_ROTTEN_WOOL.get());
        map.put(DyeColor.CYAN, (ItemLike)SZBlocks.CYAN_ROTTEN_WOOL.get());
        map.put(DyeColor.PURPLE, (ItemLike)SZBlocks.PURPLE_ROTTEN_WOOL.get());
        map.put(DyeColor.BLUE, (ItemLike)SZBlocks.BLUE_ROTTEN_WOOL.get());
        map.put(DyeColor.BROWN, (ItemLike)SZBlocks.BROWN_ROTTEN_WOOL.get());
        map.put(DyeColor.GREEN, (ItemLike)SZBlocks.GREEN_ROTTEN_WOOL.get());
        map.put(DyeColor.RED, (ItemLike)SZBlocks.RED_ROTTEN_WOOL.get());
        map.put(DyeColor.BLACK, (ItemLike)SZBlocks.BLACK_ROTTEN_WOOL.get());
    });
    private static final Ingredient FOOD_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.MUTTON});
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(ZombifiedSheep.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int conversionTime;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public ZombifiedSheep(EntityType<? extends Sheep> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CONVERTING_ID, (Object)false);
    }

    protected void registerGoals() {
        this.eatBlockGoal = new EatBlockGoal((Mob)this);
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new SPPTemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false, stack -> stack.is(ItemTags.WOOL)));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)this.eatBlockGoal);
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestNormalVariantTargetGoal(this, true, false));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, (double)0.23f).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public void tick() {
        AnimalUtil.tick((LivingEntity)this);
        super.tick();
    }

    public ResourceKey<LootTable> getDefaultLootTable() {
        if (this.isSheared()) {
            return this.getType().getDefaultLootTable();
        }
        return switch (this.getColor()) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> SZLoot.ZOMBIFIED_SHEEP_WHITE;
            case DyeColor.ORANGE -> SZLoot.ZOMBIFIED_SHEEP_ORANGE;
            case DyeColor.MAGENTA -> SZLoot.ZOMBIFIED_SHEEP_MAGENTA;
            case DyeColor.LIGHT_BLUE -> SZLoot.ZOMBIFIED_SHEEP_LIGHT_BLUE;
            case DyeColor.YELLOW -> SZLoot.ZOMBIFIED_SHEEP_YELLOW;
            case DyeColor.LIME -> SZLoot.ZOMBIFIED_SHEEP_LIME;
            case DyeColor.PINK -> SZLoot.ZOMBIFIED_SHEEP_PINK;
            case DyeColor.GRAY -> SZLoot.ZOMBIFIED_SHEEP_GRAY;
            case DyeColor.LIGHT_GRAY -> SZLoot.ZOMBIFIED_SHEEP_LIGHT_GRAY;
            case DyeColor.CYAN -> SZLoot.ZOMBIFIED_SHEEP_CYAN;
            case DyeColor.PURPLE -> SZLoot.ZOMBIFIED_SHEEP_PURPLE;
            case DyeColor.BLUE -> SZLoot.ZOMBIFIED_SHEEP_BLUE;
            case DyeColor.BROWN -> SZLoot.ZOMBIFIED_SHEEP_BROWN;
            case DyeColor.GREEN -> SZLoot.ZOMBIFIED_SHEEP_GREEN;
            case DyeColor.RED -> SZLoot.ZOMBIFIED_SHEEP_RED;
            case DyeColor.BLACK -> SZLoot.ZOMBIFIED_SHEEP_BLACK;
        };
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult returnValue = AnimalUtil.mobInteract((LivingEntity)this, player, hand);
        if (returnValue != InteractionResult.PASS) {
            return returnValue;
        }
        return super.mobInteract(player, hand);
    }

    public void handleEntityEvent(byte id) {
        if (!AnimalUtil.handleEntityEvent((LivingEntity)this, id)) {
            super.handleEntityEvent(id);
        }
    }

    public void shear(SoundSource category) {
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, category, 1.0f, 1.0f);
        this.setSheared(true);
        int amount = 1 + this.random.nextInt(3);
        for (int i = 0; i < amount; ++i) {
            ItemEntity item = this.spawnAtLocation(ITEM_BY_DYE.get(this.getColor()), 1);
            if (item == null) continue;
            item.setDeltaMovement(item.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
    }

    public Sheep getBreedOffspring(ServerLevel level, AgeableMob mob) {
        Sheep sheep = (Sheep)mob;
        Sheep newSheep = (Sheep)((EntityType)SZEntityTypes.ZOMBIFIED_SHEEP.get()).create((Level)level);
        newSheep.setColor(this.getOffspringColor((Animal)this, (Animal)sheep));
        return newSheep;
    }

    public List<ItemStack> onSheared(Player player, ItemStack item, Level level, BlockPos pos) {
        level.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!level.isClientSide) {
            this.setSheared(true);
            int amount = 1 + this.random.nextInt(3);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < amount; ++i) {
                items.add(new ItemStack(ITEM_BY_DYE.get(this.getColor())));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public int getBaseExperienceReward() {
        return super.getBaseExperienceReward() + 5;
    }

    public boolean isFood(ItemStack stack) {
        return AnimalUtil.isFood(stack, FOOD_ITEMS, ingredient -> ingredient.is(ItemTags.WOOL));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("ConversionTime", 99) && tag.getInt("ConversionTime") > -1) {
            this.startConverting(tag.getInt("ConversionTime"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("ConversionTime", this.isConverting() ? this.conversionTime : -1);
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.persistentAngerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    public EntityType<? extends Animal> getNormalVariant() {
        return EntityType.SHEEP;
    }

    @Override
    public void readFromVanilla(Animal animal) {
        if (animal instanceof Sheep) {
            Sheep sheep = (Sheep)animal;
            this.setColor(sheep.getColor());
            this.setSheared(sheep.isSheared());
        }
    }

    @Override
    public void writeToVanilla(Animal animal) {
        if (animal instanceof Sheep) {
            Sheep sheep = (Sheep)animal;
            sheep.setColor(this.getColor());
            sheep.setSheared(this.isSheared());
        }
    }

    @Override
    public boolean isConverting() {
        return (Boolean)this.getEntityData().get(DATA_CONVERTING_ID);
    }

    @Override
    public void setConverting() {
        this.getEntityData().set(DATA_CONVERTING_ID, (Object)true);
    }

    @Override
    public void setConversionTime(int conversionTime) {
        this.conversionTime = conversionTime;
    }

    @Override
    public int getConversionTime() {
        return this.conversionTime;
    }
}

