/*
 * Decompiled with CFR 0.152.
 */
package suszombification.entity.ai;

import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import suszombification.misc.AnimalUtil;
import suszombification.registration.SZItems;

public class SPPTemptGoal
extends TemptGoal {
    private final Ingredient ingredients;
    private final Predicate<ItemStack> ingredientPredicate;

    public SPPTemptGoal(PathfinderMob mob, double speedModifier, Ingredient ingredients, boolean canScare) {
        this(mob, speedModifier, ingredients, canScare, stack -> false);
    }

    public SPPTemptGoal(PathfinderMob mob, double speedModifier, Ingredient ingredients, boolean canScare, Predicate<ItemStack> ingredientPredicate) {
        super(mob, speedModifier, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SZItems.SUSPICIOUS_PUMPKIN_PIE.get()}), canScare);
        this.ingredients = ingredients;
        this.ingredientPredicate = ingredientPredicate;
    }

    public boolean shouldFollow(LivingEntity entity) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = entity.getItemInHand(hand);
            if (!AnimalUtil.isFood(stack, this.ingredients, this.ingredientPredicate)) continue;
            return true;
        }
        return false;
    }
}

