/*
 * Decompiled with CFR 0.152.
 */
package suszombification.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import suszombification.SZDamageSources;
import suszombification.SZTags;
import suszombification.block.RottenWoolBlock;
import suszombification.item.CandyItem;
import suszombification.item.ItemStackComponent;
import suszombification.misc.SuspiciousRitual;
import suszombification.registration.SZBlocks;
import suszombification.registration.SZDataComponents;
import suszombification.registration.SZEffects;
import suszombification.registration.SZItems;

public class SuspiciousPumpkinPieItem
extends Item {
    private static final List<PieEffect> PIE_EFFECTS = new ArrayList<PieEffect>();

    public SuspiciousPumpkinPieItem(Item.Properties properties) {
        super(properties);
    }

    public static void saveIngredient(ItemStack suspiciousPumpkinPie, ItemStack ingredient) {
        Item item = ingredient.getItem();
        if (item instanceof CandyItem) {
            CandyItem candy = (CandyItem)item;
            suspiciousPumpkinPie.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)candy.getEffects());
        }
        suspiciousPumpkinPie.set(SZDataComponents.INGREDIENT, (Object)new ItemStackComponent(ingredient.copyWithCount(1)));
    }

    public static boolean hasIngredient(ItemStack pie, Item test) {
        ItemStackComponent ingredient = (ItemStackComponent)pie.get(SZDataComponents.INGREDIENT);
        return ingredient != null && ingredient.is(test);
    }

    public static List<Item> getAllDifferentIngredients() {
        ArrayList<Item> ingredients = new ArrayList<Item>();
        for (DeferredHolder holder : SZItems.ITEMS.getEntries()) {
            Item item = (Item)holder.get();
            if (!(item instanceof CandyItem)) continue;
            CandyItem candy = (CandyItem)item;
            ingredients.add(candy);
        }
        ingredients.add((Item)SZItems.SPOILED_MILK_BUCKET.get());
        ingredients.add((Item)SZItems.ROTTEN_EGG.get());
        ingredients.add(((RottenWoolBlock)((Object)SZBlocks.WHITE_ROTTEN_WOOL.get())).asItem());
        ingredients.add(Items.GOLDEN_APPLE);
        ingredients.add(Items.ROTTEN_FLESH);
        ingredients.add(Items.CHICKEN);
        return ingredients;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, ctx, tooltip, flag);
        if (flag.isCreative()) {
            ArrayList effects = new ArrayList();
            SuspiciousPumpkinPieItem.addPotionEffects(stack, effects::add, null);
            PotionContents.addPotionTooltip(effects, tooltip::add, (float)1.0f, (float)ctx.tickRate());
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        SuspiciousPumpkinPieItem.addPotionEffects(stack, arg_0 -> ((LivingEntity)entity).addEffect(arg_0), entity);
        return super.finishUsingItem(stack, level, entity);
    }

    private static void addPotionEffects(ItemStack stack, Consumer<MobEffectInstance> effectApplier, LivingEntity entity) {
        String messageSuffix = "air";
        ChatFormatting color = ChatFormatting.GRAY;
        ((SuspiciousStewEffects)stack.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)SuspiciousStewEffects.EMPTY)).effects().forEach(entry -> effectApplier.accept(entry.createEffectInstance()));
        ItemStackComponent ingredientComponent = (ItemStackComponent)stack.get(SZDataComponents.INGREDIENT);
        if (ingredientComponent != null) {
            Player player;
            ItemStack ingredient = ingredientComponent.stack();
            boolean foundEffect = false;
            messageSuffix = BuiltInRegistries.ITEM.getKey((Object)ingredient.getItem()).getPath();
            color = ChatFormatting.GOLD;
            for (PieEffect pieEffect : PIE_EFFECTS) {
                if (!pieEffect.check.apply(ingredient).booleanValue()) continue;
                MobEffectInstance mainEffect = pieEffect.mainEffect.get();
                MobEffectInstance extraEffect = pieEffect.extraEffect.get();
                if (mainEffect != null) {
                    effectApplier.accept(mainEffect);
                }
                if (extraEffect != null) {
                    effectApplier.accept(extraEffect);
                }
                if (!pieEffect.messageSuffix.isEmpty()) {
                    messageSuffix = pieEffect.messageSuffix;
                }
                foundEffect = true;
                break;
            }
            if (!foundEffect && !(ingredient.getItem() instanceof CandyItem)) {
                if (ingredient.is(Items.GUNPOWDER)) {
                    if (entity != null && !entity.level().isClientSide) {
                        entity.level().explode(null, SZDamageSources.sppExplosion(entity.level().registryAccess()), null, entity.getX(), entity.getY(), entity.getZ(), 3.0f, false, Level.ExplosionInteraction.MOB);
                    }
                } else {
                    effectApplier.accept(new MobEffectInstance(MobEffects.POISON, 300));
                    messageSuffix = "mob_drop";
                    color = ChatFormatting.DARK_GREEN;
                }
            }
            if (ingredient.is(Items.GOLDEN_APPLE) && entity instanceof Player && (player = (Player)entity).hasEffect(MobEffects.WEAKNESS) && SuspiciousRitual.performRitual(player.level(), player)) {
                color = ChatFormatting.AQUA;
                messageSuffix = "cured_by_ritual";
            }
        }
        if (entity != null && !entity.level().isClientSide) {
            entity.sendSystemMessage((Component)Component.translatable((String)("message.suszombification.suspicious_pumpkin_pie." + messageSuffix)).withStyle(color));
        }
    }

    static {
        PIE_EFFECTS.add(new PieEffect(stack -> stack.is((Item)SZItems.SPOILED_MILK_BUCKET.get()), () -> new MobEffectInstance(SZEffects.AMPLIFYING, 1), () -> new MobEffectInstance(MobEffects.CONFUSION, 100), ChatFormatting.DARK_PURPLE, ""));
        PIE_EFFECTS.add(new PieEffect(stack -> stack.is((Item)SZItems.ROTTEN_EGG.get()), () -> new MobEffectInstance(SZEffects.STENCH, 2400), () -> new MobEffectInstance(MobEffects.CONFUSION, 100), ChatFormatting.DARK_PURPLE, ""));
        PIE_EFFECTS.add(new PieEffect(stack -> stack.is(SZTags.Items.ROTTEN_WOOL), () -> new MobEffectInstance(SZEffects.CUSHION, 2400), () -> new MobEffectInstance(MobEffects.CONFUSION, 100), ChatFormatting.DARK_PURPLE, "rotten_wool"));
        PIE_EFFECTS.add(new PieEffect(stack -> stack.is(Items.GOLDEN_APPLE), () -> new MobEffectInstance(MobEffects.REGENERATION, 200, 1), () -> new MobEffectInstance(MobEffects.ABSORPTION, 2400), ChatFormatting.AQUA, ""));
        PIE_EFFECTS.add(new PieEffect(stack -> stack.is(Items.ROTTEN_FLESH), () -> new MobEffectInstance(SZEffects.DECOMPOSING, 600), () -> null, ChatFormatting.AQUA, ""));
    }

    public record PieEffect(Function<ItemStack, Boolean> check, Supplier<MobEffectInstance> mainEffect, Supplier<MobEffectInstance> extraEffect, ChatFormatting displayColor, String messageSuffix) {
    }
}

