/*
 * Decompiled with CFR 0.152.
 */
package suszombification.item;

import com.mojang.datafixers.util.Unit;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import suszombification.registration.SZDataComponents;
import suszombification.registration.SZEffects;

public class TrophyItem
extends BlockItem {
    public TrophyItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.getDifficulty() != Difficulty.PEACEFUL) {
            Player player = (Player)entity;
            if (!(player.getAbilities().instabuild || player.isSpectator() || player.hasEffect(SZEffects.ZOMBIES_CURSE) || stack.has(SZDataComponents.CURSE_GIVEN))) {
                stack.set(SZDataComponents.CURSE_GIVEN, (Object)Unit.INSTANCE);
                player.playSound(SoundEvents.WITHER_SPAWN, 1.0f, 0.9f);
                player.playSound(SoundEvents.ZOMBIE_AMBIENT, 0.5f, 0.8f);
                player.addEffect(new MobEffectInstance(SZEffects.ZOMBIES_CURSE, -1));
                if (!level.isClientSide) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.suszombification.curse.warning").withStyle(ChatFormatting.RED));
                }
            }
        }
    }
}

