/*
 * Decompiled with CFR 0.152.
 */
package suszombification.misc;

import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;
import suszombification.entity.ZombifiedAnimal;
import suszombification.item.ItemStackComponent;
import suszombification.item.SuspiciousPumpkinPieItem;
import suszombification.registration.SZDataComponents;
import suszombification.registration.SZItems;

public class AnimalUtil {
    private AnimalUtil() {
    }

    public static void tick(LivingEntity me) {
        ZombifiedAnimal zombifiedAnimal;
        if (!me.level().isClientSide && me.isAlive() && (zombifiedAnimal = (ZombifiedAnimal)me).isConverting()) {
            zombifiedAnimal.setConversionTime(zombifiedAnimal.getConversionTime() - zombifiedAnimal.getConversionProgress());
            if (zombifiedAnimal.getConversionTime() <= 0) {
                if (EventHooks.canLivingConvert((LivingEntity)me, zombifiedAnimal.getNormalVariant(), zombifiedAnimal::setConversionTime)) {
                    zombifiedAnimal.finishConversion((ServerLevel)me.level());
                }
            }
        }
    }

    public static InteractionResult mobInteract(LivingEntity me, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is((Item)SZItems.SUSPICIOUS_PUMPKIN_PIE.get()) && SuspiciousPumpkinPieItem.hasIngredient(stack, Items.GOLDEN_APPLE)) {
            if (me.hasEffect(MobEffects.WEAKNESS)) {
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                if (!me.level().isClientSide) {
                    ((ZombifiedAnimal)me).startConverting(me.getRandom().nextInt(2401) + 3600);
                }
                me.level().gameEvent((Entity)me, (Holder)GameEvent.ENTITY_INTERACT, me.getEyePosition());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static boolean handleEntityEvent(LivingEntity me, byte id) {
        if (id == 16) {
            if (!me.isSilent()) {
                me.level().playLocalSound(me.position().x, me.getEyeY(), me.position().z, SoundEvents.ZOMBIE_VILLAGER_CURE, me.getSoundSource(), 1.0f + me.getRandom().nextFloat(), me.getRandom().nextFloat() * 0.7f + 0.3f, false);
            }
            return true;
        }
        return false;
    }

    public static boolean isFood(ItemStack stack, Ingredient foodItems) {
        return AnimalUtil.isFood(stack, foodItems, $ -> true);
    }

    public static boolean isFood(ItemStack stack, Ingredient foodItems, Predicate<ItemStack> extraTest) {
        if (stack.is((Item)SZItems.SUSPICIOUS_PUMPKIN_PIE.get())) {
            ItemStackComponent ingredient = (ItemStackComponent)stack.get(SZDataComponents.INGREDIENT);
            return ingredient != null && (foodItems.test(ingredient.stack()) || extraTest.test(ingredient.stack()));
        }
        return false;
    }
}

