/*
 * Decompiled with CFR 0.152.
 */
package suszombification.misc;

import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import suszombification.SZTags;
import suszombification.item.CandyItem;
import suszombification.item.SuspiciousPumpkinPieItem;
import suszombification.registration.SZItems;
import suszombification.registration.SZRecipeSerializers;

public class SuspiciousPumpkinPieRecipe
extends CustomRecipe {
    private static final Ingredient INGREDIENTS = Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE, Items.ROTTEN_FLESH, Items.CHICKEN, Items.FEATHER, Items.BEEF, Items.LEATHER, Items.PORKCHOP, Items.MUTTON, Items.STRING, Items.GUNPOWDER, (ItemLike)SZItems.SPOILED_MILK_BUCKET.get(), (ItemLike)SZItems.ROTTEN_EGG.get()});

    public SuspiciousPumpkinPieRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput inv, Level level) {
        boolean hasSpecialIngredient = false;
        boolean hasEgg = false;
        boolean hasSugar = false;
        boolean hasPumpkin = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(Items.SUGAR) && !hasSugar) {
                hasSugar = true;
                continue;
            }
            if (stack.is(Items.EGG) && !hasEgg) {
                hasEgg = true;
                continue;
            }
            if (this.isIngredient(stack) && !hasSpecialIngredient) {
                hasSpecialIngredient = true;
                continue;
            }
            if (!stack.is(Blocks.PUMPKIN.asItem()) || hasPumpkin) {
                return false;
            }
            hasPumpkin = true;
        }
        return hasSpecialIngredient && hasSugar && hasEgg && hasPumpkin;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider lookupProvider) {
        ItemStack ingredient = ItemStack.EMPTY;
        ItemStack suspiciousPumpkinPie = new ItemStack((ItemLike)SZItems.SUSPICIOUS_PUMPKIN_PIE.get(), 1);
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !this.isIngredient(stack)) continue;
            ingredient = stack.copy();
            break;
        }
        SuspiciousPumpkinPieItem.saveIngredient(suspiciousPumpkinPie, ingredient);
        return suspiciousPumpkinPie;
    }

    private boolean isIngredient(ItemStack stack) {
        return stack.getItem() instanceof CandyItem || INGREDIENTS.test(stack) || stack.is(ItemTags.WOOL) || stack.is(SZTags.Items.ROTTEN_WOOL);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SZRecipeSerializers.SUSPICIOUS_PUMPKIN_PIE.get();
    }
}

