/*
 * Decompiled with CFR 0.152.
 */
package suszombification.misc;

import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import suszombification.SZDamageSources;
import suszombification.SZTags;
import suszombification.entity.ZombifiedAnimal;
import suszombification.registration.SZEffects;

public final class SuspiciousRitual {
    private static final Predicate<BlockState> WOODEN_FENCE = state -> state.is(BlockTags.WOODEN_FENCES);
    private static final Predicate<BlockState> CHISELED_STONE_BRICKS = state -> state.is(Blocks.CHISELED_STONE_BRICKS);
    private static final Predicate<BlockState> ANY_OTHER_STONE_BRICKS = state -> state.is(BlockTags.STONE_BRICKS) && !CHISELED_STONE_BRICKS.test((BlockState)state);
    private static final Predicate<BlockState> PUMPKIN = state -> state.is(Blocks.PUMPKIN);
    private static final Predicate<BlockState> REDSTONE_TORCH = state -> state.is(Blocks.REDSTONE_TORCH);
    private static final BiPredicate<BlockState, Direction> CARVED_PUMPKIN = (state, dir) -> state.is(Blocks.CARVED_PUMPKIN) && state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == dir;
    private static final List<StructurePart> STRUCTURE_PARTS = List.of(new StructurePosition(0, 0, 0, WOODEN_FENCE), new StructurePosition(0, -1, 0, CHISELED_STONE_BRICKS), new StructureArea(-2, -1, -2, 2, -1, -1, ANY_OTHER_STONE_BRICKS), new StructureArea(-2, -1, 0, -1, -1, 0, ANY_OTHER_STONE_BRICKS), new StructureArea(1, -1, 0, 2, -1, 0, ANY_OTHER_STONE_BRICKS), new StructureArea(-2, -1, 1, 2, -1, 2, ANY_OTHER_STONE_BRICKS), new StructurePosition(-2, 0, -2, PUMPKIN), new StructurePosition(-2, 0, 2, PUMPKIN), new StructurePosition(2, 0, -2, PUMPKIN), new StructurePosition(2, 0, 2, PUMPKIN), new StructurePosition(-2, 1, -2, REDSTONE_TORCH), new StructurePosition(-2, 1, 2, REDSTONE_TORCH), new StructurePosition(2, 1, -2, REDSTONE_TORCH), new StructurePosition(2, 1, 2, REDSTONE_TORCH), new StructurePosition(-3, 0, 0, CHISELED_STONE_BRICKS), new StructurePosition(3, 0, 0, CHISELED_STONE_BRICKS), new StructurePosition(0, 0, -3, CHISELED_STONE_BRICKS), new StructurePosition(0, 0, 3, CHISELED_STONE_BRICKS), new StructurePosition(-3, 1, 0, state -> CARVED_PUMPKIN.test((BlockState)state, Direction.EAST)), new StructurePosition(3, 1, 0, state -> CARVED_PUMPKIN.test((BlockState)state, Direction.WEST)), new StructurePosition(0, 1, -3, state -> CARVED_PUMPKIN.test((BlockState)state, Direction.SOUTH)), new StructurePosition(0, 1, 3, state -> CARVED_PUMPKIN.test((BlockState)state, Direction.NORTH)));

    public static boolean isStructurePresent(Level level, BlockPos structureOrigin, boolean includeTrophy) {
        boolean isStructurePresent = STRUCTURE_PARTS.stream().allMatch(part -> part.checkPart(level, structureOrigin));
        if (includeTrophy) {
            isStructurePresent &= level.getBlockState(structureOrigin.above()).is(SZTags.Blocks.TROPHIES);
        }
        return isStructurePresent;
    }

    public static boolean performRitual(Level level, Player player) {
        if (level.isNight() || player.getAbilities().instabuild) {
            Optional<Animal> potentialSacrifice = level.getEntitiesOfClass(Animal.class, new AABB(player.position(), player.position()).inflate(3.0), ZombifiedAnimal.class::isInstance).stream().filter(SuspiciousRitual::isGoodSacrifice).findFirst();
            if (potentialSacrifice.isPresent()) {
                Animal sacrifice = potentialSacrifice.get();
                Entity leashHolder = sacrifice.getLeashHolder();
                BlockPos ritualOrigin = leashHolder.blockPosition();
                if (player.distanceTo(leashHolder) <= 3.0f && Math.floor(player.position().y) >= (double)ritualOrigin.getY()) {
                    sacrifice.hurt(SZDamageSources.ritualSacrifice(player, level.registryAccess()), Float.MAX_VALUE);
                    leashHolder.remove(Entity.RemovalReason.DISCARDED);
                    level.removeBlock(ritualOrigin.above(), false);
                    player.removeAllEffects();
                    player.addEffect(new MobEffectInstance(SZEffects.ZOMBIES_GRACE, 24000, 0, false, false, true));
                    level.playSound(null, ritualOrigin, SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    level.playSound(null, ritualOrigin, SoundEvents.ZOMBIE_AMBIENT, SoundSource.NEUTRAL, 2.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.2f + 1.0f);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isGoodSacrifice(Animal animal) {
        if (!animal.isLeashed()) {
            return false;
        }
        Entity entity = animal.getLeashHolder();
        if (!(entity instanceof LeashFenceKnotEntity)) {
            return false;
        }
        LeashFenceKnotEntity leashKnot = (LeashFenceKnotEntity)entity;
        if (animal.distanceTo((Entity)leashKnot) > 3.0f) {
            return false;
        }
        if (Math.floor(animal.position().y) < Math.floor(leashKnot.position().y)) {
            return false;
        }
        return SuspiciousRitual.isStructurePresent(animal.level(), leashKnot.blockPosition(), true);
    }

    public static void maybeSendInfoMessages(Mob leashedMob, Level level, BlockPos pos, Player player) {
        BlockState state;
        if (!level.isClientSide && (leashedMob != null || !level.isNight()) && (state = level.getBlockState(pos)).is(BlockTags.WOODEN_FENCES) && SuspiciousRitual.isStructurePresent(level, pos, false)) {
            if (!(leashedMob instanceof ZombifiedAnimal)) {
                player.displayClientMessage((Component)Component.translatable((String)"message.suszombification.ritual.need_zombified_animal"), true);
            } else if (!level.isNight()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.suszombification.ritual.need_night"), true);
            }
        }
    }

    private static interface StructurePart {
        public boolean checkPart(Level var1, BlockPos var2);
    }

    private record StructurePosition(int x, int y, int z, Predicate<BlockState> check) implements StructurePart
    {
        @Override
        public boolean checkPart(Level level, BlockPos structureOrigin) {
            return this.check.test(level.getBlockState(structureOrigin.offset(this.x, this.y, this.z)));
        }
    }

    private record StructureArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Predicate<BlockState> check) implements StructurePart
    {
        @Override
        public boolean checkPart(Level level, BlockPos structureOrigin) {
            for (int x = this.minX; x <= this.maxX; ++x) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    for (int z = this.minZ; z <= this.maxZ; ++z) {
                        if (this.check.test(level.getBlockState(structureOrigin.offset(x, y, z)))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

