/*
 * Decompiled with CFR 0.152.
 */
package suszombification.mixin;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import suszombification.entity.ZombifiedAnimal;
import suszombification.entity.ai.NearestNormalVariantTargetGoal;
import suszombification.entity.ai.SPPTemptGoal;
import suszombification.misc.AnimalUtil;

@Mixin(value={ZombieHorse.class})
public class ZombieHorseMixin
extends AbstractHorse
implements ZombifiedAnimal,
NeutralMob {
    private static final Ingredient FOOD_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER});
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(ZombieHorse.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(ZombieHorse.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int conversionTime;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    protected ZombieHorseMixin(EntityType<? extends AbstractHorse> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 1.2));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0, AbstractHorse.class));
        this.goalSelector.addGoal(3, (Goal)new SPPTemptGoal((PathfinderMob)this, 1.0, Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER}), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestNormalVariantTargetGoal(this, true, false));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Inject(method={"createAttributes"}, at={@At(value="HEAD")}, cancellable=true)
    private static void suszombification$createAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> callback) {
        callback.setReturnValue((Object)ZombieHorseMixin.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ATTACK_DAMAGE, 2.0));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CONVERTING_ID, (Object)false);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void tick() {
        AnimalUtil.tick((LivingEntity)this);
        super.tick();
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void suszombification$mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> callback) {
        InteractionResult returnValue = AnimalUtil.mobInteract((LivingEntity)this, player, hand);
        if (returnValue != InteractionResult.PASS) {
            callback.setReturnValue((Object)returnValue);
        }
    }

    public void handleEntityEvent(byte id) {
        if (!AnimalUtil.handleEntityEvent((LivingEntity)this, id)) {
            super.handleEntityEvent(id);
        }
    }

    public int getBaseExperienceReward() {
        return super.getBaseExperienceReward() + 5;
    }

    public boolean isFood(ItemStack stack) {
        return AnimalUtil.isFood(stack, FOOD_ITEMS) || super.isFood(stack);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("ConversionTime", 99) && tag.getInt("ConversionTime") > -1) {
            this.startConverting(tag.getInt("ConversionTime"));
        }
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        tag.putInt("Variant", ((Integer)this.entityData.get(DATA_ID_TYPE_VARIANT)).intValue());
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.persistentAngerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    public EntityType<? extends Animal> getNormalVariant() {
        return EntityType.HORSE;
    }

    @Override
    public void readFromVanilla(Animal animal) {
        if (animal instanceof Horse) {
            Horse horse = (Horse)animal;
            this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)horse.getTypeVariant());
        }
    }

    @Override
    public void writeToVanilla(Animal animal) {
        if (animal instanceof Horse) {
            Horse horse = (Horse)animal;
            horse.setTypeVariant(((Integer)this.entityData.get(DATA_ID_TYPE_VARIANT)).intValue());
        }
    }

    @Override
    public boolean isConverting() {
        return (Boolean)this.entityData.get(DATA_CONVERTING_ID);
    }

    @Override
    public void setConverting() {
        this.entityData.set(DATA_CONVERTING_ID, (Object)true);
    }

    @Override
    public void setConversionTime(int conversionTime) {
        this.conversionTime = conversionTime;
    }

    @Override
    public int getConversionTime() {
        return this.conversionTime;
    }
}

