/*
 * Decompiled with CFR 0.152.
 */
package suszombification.mixin.datafix;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Set;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStackComponentizationFix.class})
public class ItemStackComponentizationFixMixin {
    @Unique
    private static final Set<String> TROPHIES = Set.of("suszombification:carrot_trophy", "suszombification:potato_trophy", "suszombification:iron_ingot_trophy");

    @Inject(method={"fixItemStack"}, at={@At(value="TAIL")})
    private static void suszombification$fixItemStacks(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic, CallbackInfo ci) {
        OptionalDynamic curseGiven;
        if (itemStackData.is(TROPHIES) && (curseGiven = itemStackData.removeTag("CurseGiven")).get().isSuccess()) {
            itemStackData.setComponent("suszombification:curse_given", dynamic.emptyMap());
        }
        if (itemStackData.is("suszombification:suspicious_pumpkin_pie")) {
            itemStackData.removeTag("Effects").result().ifPresent(effects -> itemStackData.setComponent("minecraft:suspicious_stew_effects", dynamic.createList(effects.asList(entry -> dynamic.emptyMap().set("duration", dynamic.createInt(entry.get("EffectDuration").asInt(0))).set("id", dynamic.createString(entry.get("forge:effect_id").asString("minecraft:speed")))).stream())));
            itemStackData.moveTagToComponent("effects", "minecraft:suspicious_stew_effects");
            itemStackData.removeTag("Ingredient").result().ifPresent(ingredient -> itemStackData.setComponent("suszombification:ingredient", dynamic.emptyMap().set("stack", ingredient)));
        }
    }
}

