/*
 * Decompiled with CFR 0.152.
 */
package suszombification.registration;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import suszombification.entity.ThrownRottenEgg;
import suszombification.entity.ZombifiedCat;
import suszombification.entity.ZombifiedChicken;
import suszombification.entity.ZombifiedCow;
import suszombification.entity.ZombifiedPig;
import suszombification.entity.ZombifiedSheep;

@EventBusSubscriber(modid="suszombification", bus=EventBusSubscriber.Bus.MOD)
public class SZEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"suszombification");
    public static final DeferredHolder<EntityType<?>, EntityType<ZombifiedCat>> ZOMBIFIED_CAT = ENTITY_TYPES.register("zombified_cat", () -> EntityType.Builder.of(ZombifiedCat::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.7f).clientTrackingRange(8).build("suszombification:zombified_cat"));
    public static final DeferredHolder<EntityType<?>, EntityType<ZombifiedChicken>> ZOMBIFIED_CHICKEN = ENTITY_TYPES.register("zombified_chicken", () -> EntityType.Builder.of(ZombifiedChicken::new, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.7f).clientTrackingRange(10).build("suszombification:zombified_chicken"));
    public static final DeferredHolder<EntityType<?>, EntityType<ZombifiedCow>> ZOMBIFIED_COW = ENTITY_TYPES.register("zombified_cow", () -> EntityType.Builder.of(ZombifiedCow::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.4f).clientTrackingRange(10).build("suszombification:zombified_cow"));
    public static final DeferredHolder<EntityType<?>, EntityType<ZombifiedPig>> ZOMBIFIED_PIG = ENTITY_TYPES.register("zombified_pig", () -> EntityType.Builder.of(ZombifiedPig::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 0.9f).clientTrackingRange(10).build("suszombification:zombified_pig"));
    public static final DeferredHolder<EntityType<?>, EntityType<ZombifiedSheep>> ZOMBIFIED_SHEEP = ENTITY_TYPES.register("zombified_sheep", () -> EntityType.Builder.of(ZombifiedSheep::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.3f).clientTrackingRange(10).build("suszombification:zombified_sheep"));
    public static final DeferredHolder<EntityType<?>, EntityType<ThrownRottenEgg>> ROTTEN_EGG = ENTITY_TYPES.register("rotten_egg", () -> EntityType.Builder.of(ThrownRottenEgg::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build("suszombification:rotten_egg"));

    private SZEntityTypes() {
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)ZOMBIFIED_CAT.get(), ZombifiedCat.createAttributes().build());
        event.put((EntityType)ZOMBIFIED_CHICKEN.get(), ZombifiedChicken.createAttributes().build());
        event.put((EntityType)ZOMBIFIED_COW.get(), ZombifiedCow.createAttributes().build());
        event.put((EntityType)ZOMBIFIED_PIG.get(), ZombifiedPig.createAttributes().build());
        event.put((EntityType)ZOMBIFIED_SHEEP.get(), ZombifiedSheep.createAttributes().build());
    }
}

