/*
 * Decompiled with CFR 0.152.
 */
package suszombification.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import suszombification.block.entity.TrophyBlockEntity;

public class TrophyRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    public TrophyRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(TrophyBlockEntity be, float partialTick, PoseStack pose, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack stackToRender = be.getTrophyType().displayItem;
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(stackToRender, be.getLevel(), null, 0);
        Direction direction = (Direction)be.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        int additionalRotation = direction.getAxis() == Direction.Axis.X ? 180 : 0;
        pose.pushPose();
        pose.translate(0.5, 0.6, 0.5);
        pose.scale(0.7f, 0.7f, 0.7f);
        pose.mulPose(Axis.YP.rotationDegrees(direction.toYRot() + (float)additionalRotation));
        Minecraft.getInstance().getItemRenderer().render(stackToRender, ItemDisplayContext.GROUND, false, pose, bufferSource, packedLight, packedOverlay, model);
        pose.popPose();
    }
}

