/*
 * Decompiled with CFR 0.152.
 */
package suszombification.renderer;

import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import suszombification.SuspiciousZombification;
import suszombification.entity.ZombifiedChicken;

public class ZombifiedChickenRenderer
extends MobRenderer<ZombifiedChicken, ChickenModel<ZombifiedChicken>> {
    private static final ResourceLocation CHICKEN_LOCATION = SuspiciousZombification.resLoc("textures/entity/zombified_chicken.png");

    public ZombifiedChickenRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new ChickenModel(ctx.bakeLayer(ModelLayers.CHICKEN)), 0.3f);
    }

    public ResourceLocation getTextureLocation(ZombifiedChicken entity) {
        return CHICKEN_LOCATION;
    }

    protected float getBob(ZombifiedChicken entity, float partialTicks) {
        float flapLerp = Mth.lerp((float)partialTicks, (float)entity.getPreviousFlap(), (float)entity.getFlap());
        float flapSpeedLerp = Mth.lerp((float)partialTicks, (float)entity.getPreviousFlapSpeed(), (float)entity.getFlapSpeed());
        return (Mth.sin((float)flapLerp) + 1.0f) * flapSpeedLerp;
    }

    protected boolean isShaking(ZombifiedChicken chicken) {
        return super.isShaking((LivingEntity)chicken) || chicken.isConverting();
    }
}

