/*
 * Decompiled with CFR 0.152.
 */
package suszombification.renderer;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import suszombification.SuspiciousZombification;
import suszombification.entity.ZombifiedSheep;
import suszombification.renderer.layers.ZombifiedSheepFurLayer;

public class ZombifiedSheepRenderer
extends MobRenderer<Sheep, SheepModel<Sheep>> {
    private static final ResourceLocation SHEEP_LOCATION = SuspiciousZombification.resLoc("textures/entity/zombified_sheep/zombified_sheep.png");

    public ZombifiedSheepRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new SheepModel(ctx.bakeLayer(ModelLayers.SHEEP)), 0.7f);
        this.addLayer((RenderLayer)new ZombifiedSheepFurLayer((RenderLayerParent<Sheep, SheepModel<Sheep>>)this, ctx.getModelSet()));
    }

    public ResourceLocation getTextureLocation(Sheep entity) {
        return SHEEP_LOCATION;
    }

    protected boolean isShaking(Sheep sheep) {
        return super.isShaking((LivingEntity)sheep) || ((ZombifiedSheep)sheep).isConverting();
    }
}

