/*
 * Decompiled with CFR 0.152.
 */
package suszombification.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SheepFurModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.SheepFurLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import suszombification.SuspiciousZombification;

public class ZombifiedSheepFurLayer
extends SheepFurLayer {
    private static final ResourceLocation SHEEP_FUR_LOCATION = SuspiciousZombification.resLoc("textures/entity/zombified_sheep/zombified_sheep_fur.png");
    private final SheepFurModel<Sheep> model;

    public ZombifiedSheepFurLayer(RenderLayerParent<Sheep, SheepModel<Sheep>> renderer, EntityModelSet modelSet) {
        super(renderer, modelSet);
        this.model = new SheepFurModel(modelSet.bakeLayer(ModelLayers.SHEEP_FUR));
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int packedLight, Sheep sheep, float limbSwing, float limbSwingAmount, float partialTicks, float age, float headYaw, float headPitch) {
        if (!sheep.isSheared()) {
            if (sheep.isInvisible()) {
                Minecraft minecraft = Minecraft.getInstance();
                boolean glowing = minecraft.shouldEntityAppearGlowing((Entity)sheep);
                if (glowing) {
                    VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.outline((ResourceLocation)SHEEP_FUR_LOCATION));
                    ((SheepModel)this.getParentModel()).copyPropertiesTo(this.model);
                    this.model.prepareMobModel(sheep, limbSwing, limbSwingAmount, partialTicks);
                    this.model.setupAnim(sheep, limbSwing, limbSwingAmount, age, headYaw, headPitch);
                    this.model.renderToBuffer(pose, vertexConsumer, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)sheep, (float)0.0f), -16777216);
                }
            } else {
                int colorToUse;
                if (sheep.hasCustomName() && "jeb_".equals(sheep.getName().getString())) {
                    int speed = 25;
                    int colorTick = sheep.tickCount / speed + sheep.getId();
                    int colorCount = DyeColor.values().length;
                    int currentColorIndex = colorTick % colorCount;
                    int nextColorIndex = (colorTick + 1) % colorCount;
                    float interp = ((float)(sheep.tickCount % speed) + partialTicks) / (float)speed;
                    int currentColor = Sheep.getColor((DyeColor)DyeColor.byId((int)currentColorIndex));
                    int nextColor = Sheep.getColor((DyeColor)DyeColor.byId((int)nextColorIndex));
                    colorToUse = FastColor.ARGB32.lerp((float)interp, (int)currentColor, (int)nextColor);
                } else {
                    colorToUse = Sheep.getColor((DyeColor)sheep.getColor());
                }
                ZombifiedSheepFurLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.model, (ResourceLocation)SHEEP_FUR_LOCATION, (PoseStack)pose, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)sheep, (float)limbSwing, (float)limbSwingAmount, (float)age, (float)headYaw, (float)headPitch, (float)partialTicks, (int)colorToUse);
            }
        }
    }
}

