/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_useful_copper.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import common.com.cursee.more_useful_copper.core.client.entity.model.animation.GolemAnimations;
import common.com.cursee.more_useful_copper.core.entity.CopperGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CopperGolemModel<T extends CopperGolem>
extends HierarchicalModel<T> {
    private final ModelPart golem;
    private final ModelPart head;

    public CopperGolemModel(ModelPart root) {
        this.golem = root.getChild("body");
        this.head = root.getChild("body").getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 40).addBox(-9.0f, -33.0f, -6.0f, 18.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 70).addBox(-4.5f, -21.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -43.0f, -7.5f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-1.0f, -36.0f, -9.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition legRight = body.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(37, 0).addBox(-7.5f, 0.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition legLeft = body.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(60, 0).addBox(1.5f, 0.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition armRight = body.addOrReplaceChild("armRight", CubeListBuilder.create().texOffs(60, 21).addBox(-13.0f, -0.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-33.0f, (float)0.0f));
        PartDefinition armLeft = body.addOrReplaceChild("armLeft", CubeListBuilder.create().texOffs(60, 58).addBox(9.0f, -0.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-33.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(CopperGolem entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(entity, netHeadYaw, headPitch, ageInTicks);
        this.animateWalk(GolemAnimations.WALK, limbSwing, limbSwingAmount, 1.0f, 1.0f);
        this.animate(entity.attackAnimationState, GolemAnimations.ATTACK, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack $$0, VertexConsumer $$1, int $$2, int $$3, int $$4) {
        this.golem.render($$0, $$1, $$2, $$3, $$4);
    }

    public ModelPart root() {
        return this.golem;
    }

    private void applyHeadRotation(CopperGolem pEntity, float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.clamp((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.clamp((float)pHeadPitch, (float)-2.5f, (float)2.5f);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
    }
}

