/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.rewrite.animation.cache.AzIdentityRegistry;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.HWGEntity;
import mod.azure.hwg.entity.MercEntity;
import mod.azure.hwg.entity.SpyEntity;
import mod.azure.hwg.entity.TechnodemonEntity;
import mod.azure.hwg.entity.TechnodemonGreaterEntity;
import mod.azure.hwg.network.PacketHandler;
import mod.azure.hwg.util.registry.HWGItems;
import mod.azure.hwg.util.registry.HWGMobs;
import mod.azure.hwg.util.registry.HWGProfession;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Mod(value="hwg")
public final class NeoForgeMod {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"hwg");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"hwg");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"hwg");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"hwg");
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"hwg");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"hwg");
    public static final DeferredRegister<MenuType<?>> CONTAIN = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"hwg");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"hwg");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"hwg");
    public static final DeferredRegister<VillagerProfession> PROFESSION = DeferredRegister.create((ResourceKey)Registries.VILLAGER_PROFESSION, (String)"hwg");
    public static final DeferredRegister<PoiType> POI_TYPE = DeferredRegister.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (String)"hwg");

    public NeoForgeMod(IEventBus modEventBus) {
        CommonMod.init();
        AzureLib.initialize();
        ModEntitySpawn.SERIALIZER.register(modEventBus);
        modEventBus.addListener(this::setup);
        ITEMS.register(modEventBus);
        BLOCKS.register(modEventBus);
        SOUNDS.register(modEventBus);
        ENTITIES.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        PARTICLES.register(modEventBus);
        TABS.register(modEventBus);
        RECIPE_SERIALIZER.register(modEventBus);
        CONTAIN.register(modEventBus);
        POI_TYPE.register(modEventBus);
        PROFESSION.register(modEventBus);
        AzureLib.hasKeyBindsInitialized = true;
        modEventBus.addListener(this::createEntityAttributes);
        modEventBus.addListener(this::createSpawnPlacements);
        NeoForge.EVENT_BUS.addListener(this::villagerTrades);
        modEventBus.addListener(this::commonSetup);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        AzIdentityRegistry.register((Item)((Item)HWGItems.FLARE_GUN.get()), (Item[])new Item[]{(Item)HWGItems.G_LAUNCHER.get(), HWGItems.FLAMETHROWER.get(), HWGItems.MINIGUN.get(), HWGItems.LUGER.get(), HWGItems.PISTOL.get(), HWGItems.SHOTGUN.get(), HWGItems.SPISTOL.get(), HWGItems.SNIPER.get(), HWGItems.MEANIE1.get(), HWGItems.MEANIE2.get(), HWGItems.GOLDEN_GUN.get(), HWGItems.ROCKETLAUNCHER.get(), HWGItems.HELLHORSE.get(), HWGItems.SILVERGUN.get(), HWGItems.SILVERHELLHORSE.get(), HWGItems.AK47.get(), HWGItems.SMG.get(), HWGItems.TOMMYGUN.get(), HWGItems.BALROG.get(), HWGItems.BRIMSTONE.get(), HWGItems.INCINERATOR.get()});
    }

    public void villagerTrades(VillagerTradesEvent event) {
        if (event.getType() == HWGProfession.GUNSMITH.get()) {
            event.getTrades().put(1, List.of(new VillagerTrades.EmeraldForItems((ItemLike)Items.GUNPOWDER, 1, 16, 2)));
            event.getTrades().put(1, List.of(new VillagerTrades.ItemsForEmeralds(Items.IRON_NUGGET, 2, 1, 16, 1)));
            event.getTrades().put(2, List.of(new VillagerTrades.EmeraldForItems((ItemLike)HWGItems.BULLETS.get(), 2, 16, 10)));
            event.getTrades().put(2, List.of(new VillagerTrades.EmeraldForItems((ItemLike)HWGItems.PISTOL.get(), 5, 16, 20)));
            event.getTrades().put(2, List.of(new VillagerTrades.EmeraldForItems((ItemLike)HWGItems.LUGER.get(), 5, 16, 20)));
            event.getTrades().put(3, List.of(new VillagerTrades.EmeraldForItems((ItemLike)HWGItems.SHOTGUN_SHELL.get(), 16, 16, 30)));
            event.getTrades().put(3, List.of(new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)Items.IRON_INGOT, 3, 1, (Item)HWGItems.SMG.get(), 1, 16, 30, 0.05f)));
            event.getTrades().put(3, List.of(new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)Items.IRON_INGOT, 3, 1, (Item)HWGItems.TOMMYGUN.get(), 1, 16, 30, 0.05f)));
            event.getTrades().put(4, List.of(new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)HWGItems.FUEL_TANK.get(), 1, 4, (Item)HWGItems.FLAMETHROWER.get(), 1, 16, 40, 0.05f)));
            event.getTrades().put(4, List.of(new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)Items.IRON_INGOT, 6, 4, (Item)HWGItems.SHOTGUN.get(), 1, 16, 40, 0.05f)));
            event.getTrades().put(4, List.of(new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)Items.GUNPOWDER, 8, 4, HWGItems.BULLETS.get(), 48, 16, 50, 0.05f)));
            event.getTrades().put(5, List.of(new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)Items.IRON_INGOT, 18, 8, (Item)HWGItems.ROCKETLAUNCHER.get(), 1, 16, 60, 0.05f)));
            event.getTrades().put(5, List.of(new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)Items.IRON_INGOT, 18, 8, (Item)HWGItems.G_LAUNCHER.get(), 1, 16, 60, 0.05f)));
            event.getTrades().put(5, List.of(new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)Items.IRON_INGOT, 18, 8, (Item)HWGItems.SNIPER.get(), 1, 16, 60, 0.05f)));
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        new PacketHandler();
        PacketHandler.registerMessages();
    }

    public void createEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(HWGMobs.SPY.get(), SpyEntity.createMobAttributes().build());
        event.put(HWGMobs.MERC.get(), MercEntity.createMobAttributes().build());
        event.put(HWGMobs.TECHNOLESSER.get(), TechnodemonEntity.createMobAttributes().build());
        event.put(HWGMobs.TECHNOGREATER.get(), TechnodemonGreaterEntity.createMobAttributes().build());
    }

    public void createSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register(HWGMobs.TECHNOLESSER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HWGEntity::canNetherSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(HWGMobs.TECHNOGREATER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HWGEntity::canNetherSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(HWGMobs.MERC.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MercEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(HWGMobs.SPY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpyEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    record ModEntitySpawn(HolderSet<Biome> biomes, MobSpawnSettings.SpawnerData spawn) implements BiomeModifier
    {
        public static DeferredRegister<MapCodec<? extends BiomeModifier>> SERIALIZER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"hwg");
        static Supplier<MapCodec<ModEntitySpawn>> JARJAR_SPAWN_CODEC = SERIALIZER.register("mobspawns", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ModEntitySpawn::biomes), (App)MobSpawnSettings.SpawnerData.CODEC.fieldOf("spawn").forGetter(ModEntitySpawn::spawn)).apply((Applicative)builder, ModEntitySpawn::new)));

        public void modify(@NotNull Holder<Biome> biome, @NotNull BiomeModifier.Phase phase, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome)) {
                builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, this.spawn);
            }
        }

        @NotNull
        public MapCodec<? extends BiomeModifier> codec() {
            return JARJAR_SPAWN_CODEC.get();
        }
    }
}

