/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.blocks;

import com.mojang.serialization.MapCodec;
import mod.azure.hwg.entity.projectiles.FuelTankEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FuelTankBlock
extends Block {
    public static final MapCodec<Block> CODEC = FuelTankBlock.simpleCodec(FuelTankBlock::new);

    public FuelTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    private static void primeBlock(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            FuelTankEntity tntEntity = new FuelTankEntity(world, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
            world.addFreshEntity((Entity)tntEntity);
        }
    }

    public boolean dropFromExplosion(@NotNull Explosion explosion) {
        return false;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull BlockHitResult hitResult) {
        ItemStack itemStack = player.getItemInHand(player.getUsedItemHand());
        Item item = itemStack.getItem();
        if (item != Items.FLINT_AND_STEEL && item != Items.FIRE_CHARGE) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        FuelTankBlock.primeBlock(level, pos);
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void onProjectileHit(Level world, @NotNull BlockState state, @NotNull BlockHitResult hit, @NotNull Projectile projectile) {
        if (!world.isClientSide) {
            BlockPos blockPos = hit.getBlockPos();
            FuelTankBlock.primeBlock(world, blockPos);
            world.removeBlock(blockPos, false);
        }
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter view, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.box((double)0.33f, (double)0.0, (double)0.33f, (double)0.67f, (double)1.0, (double)0.67f);
    }
}

