/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.client.gui;

import mod.azure.hwg.client.gui.GunTableScreenHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import org.jetbrains.annotations.NotNull;

public class GunTableInventory
implements Container {
    private final GunTableScreenHandler container;
    private final NonNullList<ItemStack> stacks = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
    public CustomRecipeInput recipeInput;

    public GunTableInventory(GunTableScreenHandler container) {
        this.container = container;
        this.recipeInput = new CustomRecipeInput(this);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack getRecipeItem(int slot) {
        return this.getItem(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem(this.stacks, (int)slot, (int)amount);
        if (!itemStack.isEmpty() && slot != 5) {
            this.container.slotsChanged(this);
        }
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.stacks, (int)slot);
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        if (slot != 5) {
            this.container.slotsChanged(this);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void setChanged() {
    }

    public void clearContent() {
        this.stacks.clear();
    }

    public record CustomRecipeInput(GunTableInventory inventory) implements RecipeInput
    {
        @NotNull
        public ItemStack getItem(int i) {
            return this.inventory.getRecipeItem(i);
        }

        public int size() {
            return 5;
        }
    }
}

