/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.client.gui;

import java.util.Optional;
import mod.azure.hwg.client.gui.GunTableInventory;
import mod.azure.hwg.util.recipes.GunTableRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class GunTableOutputSlot
extends Slot {
    private final GunTableInventory gunTableInventory;
    private final Player player;
    private int amount;

    public GunTableOutputSlot(Player player, GunTableInventory gunTableInventory, int index, int x, int y) {
        super((Container)gunTableInventory, index, x, y);
        this.player = player;
        this.gunTableInventory = gunTableInventory;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.amount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    protected void onQuickCraft(@NotNull ItemStack stack, int amount) {
        this.amount += amount;
        this.checkTakeAchievements(stack);
    }

    protected void checkTakeAchievements(ItemStack stack) {
        stack.onCraftedBy(this.player.level(), this.player, this.amount);
        this.amount = 0;
    }

    public void onTake(Player player, @NotNull ItemStack stack) {
        this.checkTakeAchievements(stack);
        Optional optionalGunTableRecipe = player.level().getRecipeManager().getRecipeFor((RecipeType)GunTableRecipe.Type.INSTANCE, (RecipeInput)this.gunTableInventory.recipeInput, player.level());
        if (optionalGunTableRecipe.isPresent()) {
            GunTableRecipe gunTableRecipe = (GunTableRecipe)((RecipeHolder)optionalGunTableRecipe.get()).value();
            NonNullList defaultedList = gunTableRecipe.getRemainingItems(this.gunTableInventory.recipeInput);
            for (int i = 0; i < defaultedList.size(); ++i) {
                ItemStack itemStack = this.gunTableInventory.getItem(i);
                ItemStack itemStack2 = (ItemStack)defaultedList.get(i);
                if (!itemStack.isEmpty()) {
                    this.gunTableInventory.removeItem(i, gunTableRecipe.countRequired(i));
                    itemStack = this.gunTableInventory.getItem(i);
                }
                if (itemStack2.isEmpty()) continue;
                if (itemStack.isEmpty()) {
                    this.gunTableInventory.setItem(i, itemStack2);
                    continue;
                }
                if (ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)itemStack2) && ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)itemStack2)) {
                    itemStack2.grow(itemStack.getCount());
                    this.gunTableInventory.setItem(i, itemStack2);
                    continue;
                }
                if (this.player.getInventory().add(itemStack2)) continue;
                this.player.drop(itemStack2, false);
            }
        }
        this.setChanged();
    }
}

