/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.client.gui.GunTableScreenHandler;
import mod.azure.hwg.network.CraftingPacket;
import mod.azure.hwg.util.recipes.GunTableRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class GunTableScreen
extends AbstractContainerScreen<GunTableScreenHandler> {
    private static final ResourceLocation TEXTURE = CommonMod.modResource("textures/gui/gun_table_gui.png");
    private final WidgetButtonPage[] offers = new WidgetButtonPage[7];
    private int selectedIndex;
    private int indexStartOffset;
    private boolean scrolling;

    public GunTableScreen(GunTableScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.imageWidth = 300;
        this.inventoryLabelX = 107;
    }

    private void syncRecipeIndex() {
        ((GunTableScreenHandler)this.menu).setRecipeIndex(this.selectedIndex);
        ((GunTableScreenHandler)this.menu).switchTo(this.selectedIndex);
        CraftingPacket.send(this.selectedIndex);
    }

    protected void init() {
        super.init();
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        int k = j + 18;
        for (int l = 0; l < 7; ++l) {
            this.offers[l] = (WidgetButtonPage)this.addRenderableWidget((GuiEventListener)new WidgetButtonPage(i, k, l, button -> {
                if (button instanceof WidgetButtonPage) {
                    WidgetButtonPage widgetButtonPage = (WidgetButtonPage)button;
                    this.selectedIndex = widgetButtonPage.getIndex() + this.indexStartOffset;
                    this.syncRecipeIndex();
                }
            }));
            k += 20;
        }
    }

    protected void renderLabels(GuiGraphics matrices, int mouseX, int mouseY) {
        matrices.drawString(this.font, this.title, 75 + this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, 6, 0x404040, false);
    }

    protected void renderBg(GuiGraphics matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int i = (this.width - this.imageWidth) / 2 - 5;
        int j = (this.height - this.imageHeight) / 2;
        matrices.blit(TEXTURE, i, j, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
    }

    private void renderScrollbar(GuiGraphics matrices, int x, int y, List<RecipeHolder<GunTableRecipe>> tradeOffers) {
        int i = tradeOffers.size() + 1 - 7;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int m = Math.min(113, this.indexStartOffset * k);
            if (this.indexStartOffset == i - 1) {
                m = 113;
            }
            matrices.blit(TEXTURE, x + 113, y + 18 + m, 0, 0.0f, 199.0f, 6, 27, 512, 256);
        } else {
            matrices.blit(TEXTURE, x + 113, y + 18, 0, 6.0f, 199.0f, 6, 27, 512, 256);
        }
    }

    public void render(@NotNull GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices, mouseX, mouseY, delta);
        super.render(matrices, mouseX, mouseY, delta);
        List<RecipeHolder<GunTableRecipe>> tradeOfferList = ((GunTableScreenHandler)this.menu).getRecipes();
        if (!tradeOfferList.isEmpty()) {
            int i = (this.width - this.imageWidth) / 2;
            int j = (this.height - this.imageHeight) / 2;
            int yPos = j + 17;
            int xPos = i + 10;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            this.renderScrollbar(matrices, i, j, tradeOfferList);
            int m = 0;
            for (RecipeHolder<GunTableRecipe> recipeHolder : tradeOfferList) {
                if (this.canScroll(tradeOfferList.size()) && (m < this.indexStartOffset || m >= 7 + this.indexStartOffset)) {
                    ++m;
                    continue;
                }
                GunTableRecipe gunTableRecipe = (GunTableRecipe)recipeHolder.value();
                ItemStack output = gunTableRecipe.output();
                int n = yPos + 2;
                matrices.pose().pushPose();
                this.renderIngredients(matrices, gunTableRecipe, xPos - 6, n, mouseX, mouseY);
                this.renderArrow(matrices, gunTableRecipe, i + 22, n);
                matrices.renderFakeItem(output, i + 24 + 68, n);
                matrices.renderItemDecorations(this.font, output, i + 24 + 68, n);
                if (this.isMouseOverSlot(i + 24 + 68, n, mouseX, mouseY)) {
                    matrices.renderTooltip(this.font, output, mouseX, mouseY);
                }
                matrices.pose().popPose();
                yPos += 20;
                ++m;
            }
            for (WidgetButtonPage widgetButtonPage : this.offers) {
                if (widgetButtonPage.isHovered()) {
                    widgetButtonPage.renderToolTip(matrices, mouseX, mouseY);
                }
                widgetButtonPage.visible = widgetButtonPage.index < ((GunTableScreenHandler)this.menu).getRecipes().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.renderTooltip(matrices, mouseX, mouseY);
    }

    private void renderArrow(GuiGraphics matrices, GunTableRecipe tradeOffer, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
    }

    private void renderIngredients(GuiGraphics matrices, GunTableRecipe gunTableRecipe, int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < gunTableRecipe.ingredients().size(); ++i) {
            ItemStack stack;
            ItemStack[] displayStacks = gunTableRecipe.getIngredientForSlot(i).getItems();
            if (displayStacks.length <= 0 || (stack = new ItemStack((ItemLike)displayStacks[0].getItem(), gunTableRecipe.countRequired(i))).isEmpty()) continue;
            matrices.renderFakeItem(stack, x, y);
            matrices.renderItemDecorations(this.font, stack, x, y);
            if (this.isMouseOverSlot(x, y, mouseX, mouseY)) {
                matrices.renderTooltip(this.font, stack, mouseX, mouseY);
            }
            x += 18;
        }
    }

    private boolean isMouseOverSlot(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16;
    }

    private boolean canScroll(int listSize) {
        return listSize > 7;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int i = ((GunTableScreenHandler)this.menu).getRecipes().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.indexStartOffset = (int)((double)this.indexStartOffset - scrollY);
            this.indexStartOffset = Mth.clamp((int)this.indexStartOffset, (int)0, (int)j);
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int i = ((GunTableScreenHandler)this.menu).getRecipes().size();
        if (this.scrolling) {
            int j = this.topPos + 18;
            int k = j + 139;
            int l = i - 7;
            float f = ((float)mouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.indexStartOffset = Mth.clamp((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        if (this.canScroll(((GunTableScreenHandler)this.menu).getRecipes().size()) && mouseX > (double)(i + 94) && mouseX < (double)(i + 94 + 6) && mouseY > (double)(j + 18) && mouseY <= (double)(j + 18 + 139 + 1)) {
            this.scrolling = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    class WidgetButtonPage
    extends Button {
        final int index;

        public WidgetButtonPage(int x, int y, int index, Button.OnPress onPress) {
            super(x, y, 112, 20, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
            this.index = index;
            this.visible = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void renderToolTip(GuiGraphics matrices, int mouseX, int mouseY) {
            List<RecipeHolder<GunTableRecipe>> recipes = ((GunTableScreenHandler)GunTableScreen.this.menu).getRecipes();
            if (this.isHovered && recipes.size() > this.index + GunTableScreen.this.indexStartOffset) {
                if (mouseX < this.getX() + 20) {
                    GunTableScreen.this.renderTooltip(matrices, mouseX, mouseY);
                } else if (mouseX < this.getX() + 50 && mouseX > this.getX() + 30) {
                    ItemStack stack = ((GunTableRecipe)recipes.get(this.index + GunTableScreen.this.indexStartOffset).value()).output();
                    if (!stack.isEmpty()) {
                        GunTableScreen.this.renderTooltip(matrices, mouseX, mouseY);
                    }
                } else if (mouseX > this.getX() + 65) {
                    GunTableScreen.this.renderTooltip(matrices, mouseX, mouseY);
                }
            }
        }
    }
}

