/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import mod.azure.hwg.client.gui.GunTableInventory;
import mod.azure.hwg.client.gui.GunTableOutputSlot;
import mod.azure.hwg.mixins.IngredientAccess;
import mod.azure.hwg.util.recipes.GunTableRecipe;
import mod.azure.hwg.util.registry.HWGBlocks;
import mod.azure.hwg.util.registry.ModScreens;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class GunTableScreenHandler
extends AbstractContainerMenu {
    protected static Level level;
    protected final Inventory playerInventory;
    protected final GunTableInventory gunTableInventory;
    protected final ContainerLevelAccess context;
    protected int recipeIndex;

    public GunTableScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public GunTableScreenHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(ModScreens.SCREEN_HANDLER_TYPE.get(), syncId);
        int k;
        this.playerInventory = playerInventory;
        this.gunTableInventory = new GunTableInventory(this);
        level = playerInventory.player.level();
        this.context = context;
        this.addSlot(new Slot((Container)this.gunTableInventory, 0, 155, 13));
        this.addSlot(new Slot((Container)this.gunTableInventory, 1, 175, 33));
        this.addSlot(new Slot((Container)this.gunTableInventory, 2, 135, 33));
        this.addSlot(new Slot((Container)this.gunTableInventory, 3, 142, 56));
        this.addSlot(new Slot((Container)this.gunTableInventory, 4, 168, 56));
        this.addSlot(new GunTableOutputSlot(playerInventory.player, this.gunTableInventory, 5, 238, 38));
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + k * 9 + 9, 127 + j * 18, 84 + k * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 127 + k * 18, 142));
        }
    }

    protected static void updateResult(int syncId, Level world, Player player, GunTableInventory craftingInventory) {
        if (!world.isClientSide) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            ItemStack itemStack = ItemStack.EMPTY;
            Optional optional = world.getServer().getRecipeManager().getRecipeFor((RecipeType)GunTableRecipe.Type.INSTANCE, (RecipeInput)craftingInventory.recipeInput, world);
            if (optional.isPresent()) {
                RecipeHolder craftingRecipe = (RecipeHolder)optional.get();
                itemStack = ((GunTableRecipe)craftingRecipe.value()).assemble(craftingInventory.recipeInput, (HolderLookup.Provider)level.registryAccess());
            }
            craftingInventory.setItem(5, itemStack);
            serverPlayerEntity.connection.send((Packet)new ClientboundContainerSetSlotPacket(syncId, 0, 5, itemStack));
        }
    }

    public void slotsChanged(@NotNull Container inventory) {
        this.context.execute((world, blockPos) -> GunTableScreenHandler.updateResult(this.containerId, world, this.playerInventory.player, this.gunTableInventory));
    }

    public boolean stillValid(@NotNull Player player) {
        return GunTableScreenHandler.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)HWGBlocks.GUN_TABLE.get());
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, @NotNull Slot slot) {
        return false;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index == 2) {
                if (!this.moveItemStackTo(itemStack2, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemStack2, itemStack);
            } else if (index != 0 && index != 1 ? index >= 3 && index < 30 && !this.moveItemStackTo(itemStack2, 30, 39, false) : !this.moveItemStackTo(itemStack2, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
        }
        return itemStack;
    }

    public List<RecipeHolder<GunTableRecipe>> getRecipes() {
        List immutableRecipeListView = this.playerInventory.player.level().getRecipeManager().getAllRecipesFor((RecipeType)GunTableRecipe.Type.INSTANCE);
        ArrayList<RecipeHolder<GunTableRecipe>> sortableList = new ArrayList<RecipeHolder<GunTableRecipe>>(immutableRecipeListView);
        sortableList.sort(Comparator.comparing(RecipeHolder::id));
        return sortableList;
    }

    public void setRecipeIndex(int index) {
        this.recipeIndex = index;
    }

    public void switchTo(int recipeIndex) {
        List<RecipeHolder<GunTableRecipe>> recipes = this.getRecipes();
        if (recipes.size() > recipeIndex) {
            int i;
            GunTableRecipe gunTableRecipe = (GunTableRecipe)recipes.get(recipeIndex).value();
            for (i = 0; i < 5; ++i) {
                ItemStack slotStack = this.gunTableInventory.getItem(i);
                if (slotStack.isEmpty()) continue;
                if (!this.moveItemStackTo(slotStack, 6, 39, false)) {
                    return;
                }
                this.gunTableInventory.setItem(i, slotStack);
            }
            for (i = 0; i < gunTableRecipe.ingredients().size(); ++i) {
                ItemStack[] possibleItems;
                Ingredient ingredient = gunTableRecipe.getIngredientForSlot(i);
                if (ingredient.isEmpty() || (possibleItems = ((IngredientAccess)ingredient).getMatchingStacksMod()) == null) continue;
                ItemStack first = new ItemStack((ItemLike)possibleItems[0].getItem(), gunTableRecipe.countRequired(i));
                this.autofill(i, first);
            }
        }
    }

    private void autofill(int slot, ItemStack stack) {
        if (!stack.isEmpty()) {
            int ingCount = stack.getCount();
            for (int index = 6; index < 42; ++index) {
                ItemStack slotStack = ((Slot)this.slots.get(index)).getItem();
                if (slotStack.isEmpty() || !this.equals(stack, slotStack)) continue;
                ItemStack invStack = this.gunTableInventory.getItem(slot);
                int invStackCount = invStack.isEmpty() ? 0 : invStack.getCount();
                int countToMove = Math.min(ingCount - invStackCount, slotStack.getCount());
                ItemStack slotStackCopy = slotStack.copy();
                int l = invStackCount + countToMove;
                slotStack.shrink(countToMove);
                slotStackCopy.setCount(l);
                this.gunTableInventory.setItem(slot, slotStackCopy);
                if (l >= stack.getMaxStackSize()) break;
            }
        }
    }

    private boolean equals(ItemStack itemStack, ItemStack otherItemStack) {
        return itemStack.getItem() == otherItemStack.getItem() && ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)otherItemStack);
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        if (!this.playerInventory.player.level().isClientSide) {
            ServerPlayer serverPlayer;
            if (!(!player.isAlive() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hasDisconnected())) {
                player.getInventory().placeItemBackInInventory(this.gunTableInventory.removeItemNoUpdate(0));
                player.getInventory().placeItemBackInInventory(this.gunTableInventory.removeItemNoUpdate(1));
                player.getInventory().placeItemBackInInventory(this.gunTableInventory.removeItemNoUpdate(2));
                player.getInventory().placeItemBackInInventory(this.gunTableInventory.removeItemNoUpdate(3));
                player.getInventory().placeItemBackInInventory(this.gunTableInventory.removeItemNoUpdate(4));
            } else {
                ItemStack itemStack0 = this.gunTableInventory.removeItemNoUpdate(0);
                ItemStack itemStack1 = this.gunTableInventory.removeItemNoUpdate(1);
                ItemStack itemStack2 = this.gunTableInventory.removeItemNoUpdate(2);
                ItemStack itemStack3 = this.gunTableInventory.removeItemNoUpdate(3);
                ItemStack itemStack4 = this.gunTableInventory.removeItemNoUpdate(4);
                if (!itemStack0.isEmpty()) {
                    player.drop(itemStack0, false);
                }
                if (!itemStack1.isEmpty()) {
                    player.drop(itemStack1, false);
                }
                if (!itemStack2.isEmpty()) {
                    player.drop(itemStack2, false);
                }
                if (!itemStack3.isEmpty()) {
                    player.drop(itemStack3, false);
                }
                if (!itemStack4.isEmpty()) {
                    player.drop(itemStack4, false);
                }
            }
        }
    }
}

