/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.client.render;

import com.mojang.math.Axis;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.layer.AzBlockAndItemLayer;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.SpyEntity;
import mod.azure.hwg.entity.animation.SpyAnimator;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class SpyRender<T extends SpyEntity>
extends AzEntityRenderer<SpyEntity> {
    private static final ResourceLocation MODEL = CommonMod.modResource("geo/entity/merc_illager.geo.json");

    public SpyRender(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder($ -> MODEL, entity -> CommonMod.modResource("textures/entity/spy_" + entity.getVariant() + ".png")).setAnimatorProvider(SpyAnimator::new).addRenderLayer((AzRenderLayer)new AzBlockAndItemLayer<SpyEntity>(){

            public ItemStack itemStackForBone(AzBone bone, SpyEntity animatable) {
                return switch (bone.getName()) {
                    case "rArmRuff", "rightHand" -> animatable.getItemBySlot(EquipmentSlot.MAINHAND);
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(AzBone bone, ItemStack stack, SpyEntity animatable) {
                return ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            }

            protected void renderItemForBone(AzRendererPipelineContext<SpyEntity> context, AzBone bone, ItemStack itemStack, SpyEntity animatable) {
                context.poseStack().mulPose(Axis.XP.rotationDegrees(270.0f));
                context.poseStack().mulPose(Axis.YP.rotationDegrees(0.0f));
                context.poseStack().mulPose(Axis.ZP.rotationDegrees(0.0f));
                context.poseStack().translate(0.0, 0.1, -0.1);
                super.renderItemForBone(context, bone, itemStack, (Object)animatable);
            }
        }).build(), context);
        this.shadowRadius = 0.7f;
    }
}

