/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mod.azure.hwg.entity.projectiles.BaseFlareEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class BaseFlareRender
extends EntityRenderer<BaseFlareEntity> {
    public BaseFlareRender(EntityRendererProvider.Context dispatcher) {
        super(dispatcher);
    }

    public void render(BaseFlareEntity fireworkRocketEntity, float f, float g, PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, int i) {
        matrixStack.pushPose();
        matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStack.scale(fireworkRocketEntity.tickCount > 2 ? 0.5f : 0.0f, fireworkRocketEntity.tickCount > 2 ? 0.5f : 0.0f, fireworkRocketEntity.tickCount > 2 ? 0.5f : 0.0f);
        matrixStack.popPose();
        super.render((Entity)fireworkRocketEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BaseFlareEntity fireworkRocketEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    protected int getBlockLightLevel(@NotNull BaseFlareEntity entity, @NotNull BlockPos blockPos) {
        return 15;
    }
}

