/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity;

import java.util.UUID;
import mod.azure.azurelib.common.api.common.animatable.GeoItem;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import mod.azure.hwg.entity.animation.AnimationDispatcher;
import mod.azure.hwg.entity.projectiles.BlazeRodEntity;
import mod.azure.hwg.entity.projectiles.BulletEntity;
import mod.azure.hwg.entity.projectiles.FireballEntity;
import mod.azure.hwg.entity.projectiles.FlameFiring;
import mod.azure.hwg.entity.projectiles.ShellEntity;
import mod.azure.hwg.item.enums.GunTypeEnum;
import mod.azure.hwg.item.weapons.AzureAnimatedGunItem;
import mod.azure.hwg.util.registry.HWGSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HWGEntity
extends Monster
implements NeutralMob,
Enemy {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(HWGEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(HWGEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(HWGEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private UUID targetUuid;
    public MoveAnalysis moveAnalysis;
    public AnimationDispatcher animationDispatcher;

    protected HWGEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.getNavigation().setCanFloat(true);
        this.noCulling = true;
    }

    public static boolean canNetherSpawn(EntityType<? extends HWGEntity> type, LevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        if (serverWorldAccess.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        if (spawnReason != MobSpawnType.CHUNK_GENERATION && spawnReason != MobSpawnType.NATURAL) {
            return !serverWorldAccess.getBlockState(pos.below()).is(Blocks.NETHER_WART_BLOCK);
        }
        return !serverWorldAccess.getBlockState(pos.below()).is(Blocks.NETHER_WART_BLOCK);
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANGER_TIME, (Object)0);
        builder.define(STATE, (Object)0);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int ticks) {
        this.entityData.set(ANGER_TIME, (Object)ticks);
    }

    public UUID getPersistentAngerTarget() {
        return this.targetUuid;
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    public abstract int getVariants();

    public void shoot() {
        if (!this.level().isClientSide) {
            Vec3 vector3d = this.getViewVector(1.0f);
            Item item = this.getItemBySlot(EquipmentSlot.MAINHAND).getItem();
            if (item instanceof AzureAnimatedGunItem) {
                AzureAnimatedGunItem weapon = (AzureAnimatedGunItem)item;
                Projectile bullet = this.getProjectile(weapon, weapon.getGunTypeEnum());
                bullet.setPos(this.getX() + vector3d.x * 2.0, this.getY(0.5), this.getZ() + vector3d.z * 2.0);
                bullet.shootFromRotation((Entity)this, this.getXRot(), this.getYRot(), 0.0f, 3.0f, 1.0f);
                Item item2 = this.getItemBySlot(EquipmentSlot.MAINHAND).getItem();
                if (item2 instanceof GeoItem) {
                    GeoItem geoItem = (GeoItem)item2;
                    geoItem.triggerAnim((Entity)this, GeoItem.getOrAssignId((ItemStack)this.getItemBySlot(EquipmentSlot.MAINHAND), (ServerLevel)((ServerLevel)this.level())), "controller", "firing");
                }
                this.level().playSound((Entity)this, this.blockPosition(), this.getDefaultAttackSound(weapon.getGunTypeEnum()), SoundSource.HOSTILE, 1.0f, 1.0f);
                this.level().addFreshEntity((Entity)bullet);
            }
        }
    }

    public Projectile getProjectile(AzureAnimatedGunItem item, GunTypeEnum gunTypeEnum) {
        switch (gunTypeEnum) {
            case PISTOL: 
            case LUGER: 
            case AK7: 
            case SMG: 
            case GOLDEN_PISTOL: 
            case SIL_PISTOL: 
            case HELLHORSE: 
            case MINIGUN: 
            case SNIPER: {
                return new BulletEntity(this.level(), (LivingEntity)this, Float.valueOf(item.getAttackDamage()));
            }
            case FLAMETHROWER: {
                return new FlameFiring(this.level(), (LivingEntity)this);
            }
            case BRIMSTONE: {
                return new BlazeRodEntity(this.level(), (LivingEntity)this);
            }
            case BALROG: {
                return new FireballEntity(this.level(), (LivingEntity)this);
            }
        }
        return new ShellEntity(this.level(), (LivingEntity)this);
    }

    public SoundEvent getDefaultAttackSound(GunTypeEnum gunTypeEnum) {
        switch (gunTypeEnum) {
            case PISTOL: 
            case GOLDEN_PISTOL: {
                return HWGSounds.PISTOL.get();
            }
            case LUGER: {
                return HWGSounds.LUGER.get();
            }
            case AK7: {
                return HWGSounds.AK.get();
            }
            case SMG: {
                return HWGSounds.SMG.get();
            }
            case HELLHORSE: {
                return HWGSounds.REVOLVER.get();
            }
            case SIL_PISTOL: {
                return HWGSounds.SPISTOL.get();
            }
            case FLAMETHROWER: {
                return SoundEvents.FIREWORK_ROCKET_BLAST_FAR;
            }
            case BRIMSTONE: {
                return SoundEvents.FIRECHARGE_USE;
            }
            case BALROG: {
                return (SoundEvent)SoundEvents.GENERIC_EXPLODE.value();
            }
            case SNIPER: {
                return HWGSounds.SNIPER.get();
            }
            case MINIGUN: {
                return HWGSounds.MINIGUN.get();
            }
        }
        return HWGSounds.SHOTGUN.get();
    }

    public void setAnimation(Runnable animationAction) {
        animationAction.run();
    }

    protected void handleAnimations() {
        if (this.moveAnalysis.isMoving()) {
            this.setAnimation(this.animationDispatcher::sendWalkAnimation);
        } else {
            this.setAnimation(this.animationDispatcher::sendIdleAnimation);
        }
    }
}

