/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import mod.azure.azurelib.sblforked.api.SmartBrainOwner;
import mod.azure.azurelib.sblforked.api.core.BrainActivityGroup;
import mod.azure.azurelib.sblforked.api.core.SmartBrainProvider;
import mod.azure.azurelib.sblforked.api.core.behaviour.ExtendedBehaviour;
import mod.azure.azurelib.sblforked.api.core.behaviour.FirstApplicableBehaviour;
import mod.azure.azurelib.sblforked.api.core.behaviour.OneRandomBehaviour;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.look.LookAtTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.misc.Idle;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.move.MoveToWalkTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.move.StrafeTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.path.SetRandomWalkTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.target.InvalidateAttackTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.target.SetPlayerLookTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.target.SetRandomLookTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.target.TargetOrRetaliate;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.custom.UnreachableTargetSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.vanilla.HurtBySensor;
import mod.azure.azurelib.sblforked.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import mod.azure.azurelib.sblforked.api.core.sensor.vanilla.NearbyPlayersSensor;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.HWGEntity;
import mod.azure.hwg.entity.animation.AnimationDispatcher;
import mod.azure.hwg.entity.tasks.HWGMeleeAttackTask;
import mod.azure.hwg.entity.tasks.RangedShootingAttack;
import mod.azure.hwg.item.weapons.AzureAnimatedGunItem;
import mod.azure.hwg.util.registry.HWGItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MercEntity
extends HWGEntity
implements SmartBrainOwner<MercEntity> {
    public MercEntity(EntityType<MercEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.xpReward = CommonMod.config.mobconfigs.mercconfigs.merc_exp;
    }

    public static boolean canSpawn(EntityType<? extends HWGEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return (world.getBrightness(LightLayer.BLOCK, pos) <= 8 || world.getDifficulty() == Difficulty.PEACEFUL) && MercEntity.checkAnyLightMonsterSpawnRules(type, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.MAX_HEALTH, CommonMod.config.mobconfigs.mercconfigs.merc_health).add(Attributes.ARMOR, 3.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ARMOR_TOUGHNESS, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    protected void customServerAiStep() {
        this.tickBrain((LivingEntity)this);
    }

    public List<ExtendedSensor<MercEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> target instanceof Player || target instanceof Villager), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<MercEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new StrafeTarget(), new LookAtTarget(), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<MercEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetPlayerLookTarget().stopIf(target -> {
            Player player;
            return !target.isAlive() || target instanceof Player && !(player = (Player)target).isCreative() && !player.isSpectator();
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(1.0f).startCondition(entity -> !entity.isAggressive()), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})});
    }

    public BrainActivityGroup<MercEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().stopIf(target -> {
            Player player;
            return !target.isAlive() || target instanceof Player && ((player = (Player)target).isCreative() || player.isSpectator());
        }), new RangedShootingAttack(5).whenStarting(entity -> this.setAggressive(true)).whenStarting(entity -> this.setAggressive(false)), new HWGMeleeAttackTask(3)});
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getVariant());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(tag.getInt("Variant"));
    }

    public int getVariant() {
        return Mth.clamp((int)((Integer)this.entityData.get(VARIANT)), (int)1, (int)4);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        VillagerType biomeCheck = VillagerType.byBiome((Holder)level.getBiome(this.blockPosition()));
        this.setItemSlot(EquipmentSlot.MAINHAND, this.makeInitialWeapon());
        if (biomeCheck == VillagerType.DESERT || biomeCheck == VillagerType.SAVANNA) {
            this.setVariant(1);
        } else if (biomeCheck == VillagerType.SWAMP) {
            this.setVariant(2);
        } else if (biomeCheck == VillagerType.JUNGLE) {
            this.setVariant(2);
        } else if (biomeCheck == VillagerType.SNOW) {
            this.setVariant(3);
        } else if (biomeCheck == VillagerType.TAIGA) {
            this.setVariant(4);
        } else if (biomeCheck == VillagerType.PLAINS) {
            this.setVariant(4);
        } else {
            this.setVariant(this.getRandom().nextIntBetweenInclusive(0, 5));
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    private ItemStack makeInitialWeapon() {
        List<AzureAnimatedGunItem> givenList = Arrays.asList(HWGItems.PISTOL.get(), HWGItems.LUGER.get(), HWGItems.AK47.get(), HWGItems.SHOTGUN.get(), HWGItems.SMG.get());
        int randomIndex = this.random.nextInt(givenList.size());
        AzureAnimatedGunItem randomElement = givenList.get(randomIndex);
        return new ItemStack((ItemLike)randomElement);
    }

    @Override
    public int getVariants() {
        return 4;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PILLAGER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PILLAGER_DEATH;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        return SoundEvents.PILLAGER_HURT;
    }
}

