/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import mod.azure.azurelib.sblforked.api.SmartBrainOwner;
import mod.azure.azurelib.sblforked.api.core.BrainActivityGroup;
import mod.azure.azurelib.sblforked.api.core.SmartBrainProvider;
import mod.azure.azurelib.sblforked.api.core.behaviour.ExtendedBehaviour;
import mod.azure.azurelib.sblforked.api.core.behaviour.FirstApplicableBehaviour;
import mod.azure.azurelib.sblforked.api.core.behaviour.OneRandomBehaviour;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.look.LookAtTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.misc.Idle;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.move.MoveToWalkTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.move.StrafeTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.path.SetRandomWalkTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.target.InvalidateAttackTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.target.SetPlayerLookTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.target.SetRandomLookTarget;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.target.TargetOrRetaliate;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.custom.UnreachableTargetSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.vanilla.HurtBySensor;
import mod.azure.azurelib.sblforked.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import mod.azure.azurelib.sblforked.api.core.sensor.vanilla.NearbyPlayersSensor;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.HWGEntity;
import mod.azure.hwg.entity.animation.AnimationDispatcher;
import mod.azure.hwg.entity.tasks.HWGMeleeAttackTask;
import mod.azure.hwg.entity.tasks.RangedShootingAttack;
import mod.azure.hwg.item.weapons.AzureAnimatedGunItem;
import mod.azure.hwg.util.registry.HWGItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TechnodemonEntity
extends HWGEntity
implements SmartBrainOwner<TechnodemonEntity> {
    public TechnodemonEntity(EntityType<TechnodemonEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.xpReward = CommonMod.config.mobconfigs.lesserconfigs.lesser_exp;
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ARMOR, 4.0).add(Attributes.MAX_HEALTH, CommonMod.config.mobconfigs.lesserconfigs.lesser_health).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public void tick() {
        super.tick();
        this.moveAnalysis.update();
        if (this.level().isClientSide()) {
            this.handleAnimations();
        }
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    protected void customServerAiStep() {
        this.tickBrain((LivingEntity)this);
    }

    public List<ExtendedSensor<TechnodemonEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> target instanceof Player || target instanceof Villager), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<TechnodemonEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new StrafeTarget(), new LookAtTarget(), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<TechnodemonEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetPlayerLookTarget().stopIf(target -> {
            Player player;
            return !target.isAlive() || target instanceof Player && !(player = (Player)target).isCreative() && !player.isSpectator();
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.85f).startCondition(entity -> !entity.isAggressive()), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})});
    }

    public BrainActivityGroup<TechnodemonEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().stopIf(target -> {
            Player player;
            return !target.isAlive() || target instanceof Player && ((player = (Player)target).isCreative() || player.isSpectator());
        }), new RangedShootingAttack(5).whenStarting(entity -> this.setAggressive(true)).whenStarting(entity -> this.setAggressive(false)), new HWGMeleeAttackTask(3)});
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getVariant());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(tag.getInt("Variant"));
    }

    public int getVariant() {
        return Mth.clamp((int)((Integer)this.entityData.get(VARIANT)), (int)1, (int)4);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setVariant(this.getRandom().nextInt(0, 5));
        this.setItemSlot(EquipmentSlot.MAINHAND, this.makeInitialWeapon());
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    private ItemStack makeInitialWeapon() {
        List<AzureAnimatedGunItem> givenList = Arrays.asList(HWGItems.HELLHORSE.get(), HWGItems.FLAMETHROWER.get(), HWGItems.BRIMSTONE.get());
        int randomIndex = this.getRandom().nextInt(givenList.size());
        AzureAnimatedGunItem randomElement = givenList.get(randomIndex);
        return new ItemStack((ItemLike)randomElement);
    }

    @Override
    public int getVariants() {
        return 4;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }
}

