/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.animation;

import java.util.Optional;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.cache.AzBoneCache;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.MercEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class MercAnimator
extends AzEntityAnimator<MercEntity> {
    private static final ResourceLocation ANIMATIONS = CommonMod.modResource("animations/entity/merc_illager.animation.json");

    public void registerControllers(AzAnimationControllerContainer<MercEntity> animationControllerContainer) {
        animationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"base_controller").setTransitionLength(5).build(), new AzAnimationController[0]);
    }

    @NotNull
    public ResourceLocation getAnimationLocation(MercEntity animatable) {
        return ANIMATIONS;
    }

    public void setCustomAnimations(MercEntity animatable, float partialTicks) {
        super.setCustomAnimations((Object)animatable, partialTicks);
        AzBoneCache boneCache = this.context().boneCache();
        Optional leftArm = boneCache.getBakedModel().getBone("BipedLeftArm");
        Optional rightArm = boneCache.getBakedModel().getBone("BipedRightArm");
        Optional leftLeg = boneCache.getBakedModel().getBone("BipedLeftLeg");
        Optional rightLeg = boneCache.getBakedModel().getBone("BipedRightLeg");
        if (leftArm.isPresent()) {
            ((AzBone)leftArm.get()).setRotX(Mth.cos((float)(animatable.walkAnimation.position(partialTicks) * 0.6662f)) * 2.0f * animatable.walkAnimation.speed() * 0.5f);
        }
        if (rightArm.isPresent() && !animatable.isAggressive()) {
            ((AzBone)rightArm.get()).setRotX(Mth.cos((float)(animatable.walkAnimation.position(partialTicks) * 0.6662f + (float)Math.PI)) * 2.0f * animatable.walkAnimation.speed() * 0.5f);
        }
        if (leftLeg.isPresent()) {
            ((AzBone)leftLeg.get()).setRotX(Mth.cos((float)(animatable.walkAnimation.position(partialTicks) * 0.6662f + (float)Math.PI)) * 1.4f * animatable.walkAnimation.speed() * 0.5f);
        }
        if (rightLeg.isPresent()) {
            ((AzBone)rightLeg.get()).setRotX(Mth.cos((float)(animatable.walkAnimation.position(partialTicks) * 0.6662f)) * 1.4f * animatable.walkAnimation.speed() * 0.5f);
        }
    }
}

