/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.projectiles;

import mod.azure.azurelib.common.api.common.helper.CommonUtils;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.util.registry.HWGItems;
import mod.azure.hwg.util.registry.HWGParticles;
import mod.azure.hwg.util.registry.HWGProjectiles;
import mod.azure.hwg.util.registry.HWGSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BaseFlareEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(BaseFlareEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int life;
    private int idleTicks = 0;

    public BaseFlareEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(HWGProjectiles.FLARE.get(), world);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public BaseFlareEntity(Level world, double x, double y, double z) {
        super(HWGProjectiles.FLARE.get(), world);
        this.absMoveTo(x, y, z);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public BaseFlareEntity(Level world, double x, double y, double z, boolean shotAtAngle) {
        this(world, x, y, z);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public BaseFlareEntity(Level world, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        this(world, x, y, z, shotAtAngle);
        this.setOwner(entity);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    protected void doPostHurtEffects(@NotNull LivingEntity living) {
        super.doPostHurtEffects(living);
        if (CommonMod.config.gunconfigs.bullets_disable_iframes_on_players || !(living instanceof Player)) {
            living.invulnerableTime = 0;
            living.setDeltaMovement(0.0, 0.0, 0.0);
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putShort("life", (short)this.tickCount);
        compound.putInt("Variant", this.getColor());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.tickCount = compound.getShort("life");
        this.setColor(compound.getInt("Variant"));
    }

    public int getColor() {
        return Mth.clamp((int)((Integer)this.entityData.get(COLOR)), (int)1, (int)16);
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public void tick() {
        int idleOpt = 100;
        this.idleTicks = this.getDeltaMovement().lengthSqr() < 0.01 ? ++this.idleTicks : 0;
        if (this.idleTicks < idleOpt) {
            super.tick();
        }
        if (this.tickCount >= 800 || this.isInWater()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.life == 0 && !this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), HWGSounds.FLAREGUN_SHOOT.get(), SoundSource.PLAYERS, 6.0f, 1.0f);
        }
        this.setNoGravity(false);
        ++this.life;
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.scale((double)0.99f));
        if (this.tickCount > 25) {
            this.setDeltaMovement(0.0, -0.1, 0.0);
        }
        boolean isInsideWaterBlock = this.level().isWaterAt(this.blockPosition());
        CommonUtils.spawnLightSource((Entity)this, (boolean)isInsideWaterBlock);
        if (this.level().isClientSide) {
            this.level().addParticle(this.particleColor(), true, this.getX(), this.getY() - 0.3, this.getZ(), 0.0, -this.getDeltaMovement().y * 0.17, 0.0);
        }
    }

    private ParticleOptions particleColor() {
        return switch (this.getColor()) {
            case 15 -> HWGParticles.YELLOW_FLARE.get();
            case 14 -> HWGParticles.RED_FLARE.get();
            case 13 -> HWGParticles.PURPLE_FLARE.get();
            case 12 -> HWGParticles.PINK_FLARE.get();
            case 11 -> HWGParticles.ORANGE_FLARE.get();
            case 10 -> HWGParticles.MAGENTA_FLARE.get();
            case 9 -> HWGParticles.LIME_FLARE.get();
            case 8 -> HWGParticles.LIGHTGRAY_FLARE.get();
            case 7 -> HWGParticles.LIGHTBLUE_FLARE.get();
            case 6 -> HWGParticles.GREEN_FLARE.get();
            case 5 -> HWGParticles.GRAY_FLARE.get();
            case 4 -> HWGParticles.CYAN_FLARE.get();
            case 3 -> HWGParticles.BROWN_FLARE.get();
            case 2 -> HWGParticles.BLUE_FLARE.get();
            case 1 -> HWGParticles.BLACK_FLARE.get();
            default -> HWGParticles.WHITE_FLARE.get();
        };
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public void setSoundEvent(@NotNull SoundEvent soundIn) {
        this.getDefaultHitGroundSoundEvent();
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return HWGSounds.FLAREGUN.get();
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.setSoundEvent(HWGSounds.FLAREGUN.get());
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    protected boolean tryPickup(@NotNull Player player) {
        return false;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)HWGItems.WHITE_FLARE.get());
    }
}

