/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.projectiles;

import mod.azure.hwg.CommonMod;
import mod.azure.hwg.util.Helper;
import mod.azure.hwg.util.registry.HWGProjectiles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class BlazeRodEntity
extends AbstractArrow {
    public static final EntityDataAccessor<Float> FORCED_YAW = SynchedEntityData.defineId(BlazeRodEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private int ticksInAir;
    private int idleTicks = 0;

    public BlazeRodEntity(EntityType<? extends BlazeRodEntity> entityType, Level world) {
        super(entityType, world);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public BlazeRodEntity(Level world, LivingEntity owner) {
        super(HWGProjectiles.BLAZEROD.get(), world);
    }

    public BlazeRodEntity(Level world, ItemStack stack, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        this(world, stack, x, y, z, shotAtAngle);
        this.setOwner(entity);
    }

    public BlazeRodEntity(Level world, ItemStack stack, double x, double y, double z, boolean shotAtAngle) {
        this(world, x, y, z, stack);
    }

    public BlazeRodEntity(Level world, double x, double y, double z, ItemStack stack) {
        super(HWGProjectiles.BLAZEROD.get(), world);
        this.absMoveTo(x, y, z);
    }

    protected void doPostHurtEffects(@NotNull LivingEntity living) {
        super.doPostHurtEffects(living);
        if (CommonMod.config.gunconfigs.bullets_disable_iframes_on_players || !(living instanceof Player)) {
            living.invulnerableTime = 0;
        }
    }

    public void tickDespawn() {
        ++this.ticksInAir;
        if (this.ticksInAir >= 40) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public void shoot(double x, double y, double z, float speed, float divergence) {
        super.shoot(x, y, z, speed, divergence);
        this.ticksInAir = 0;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("life", (short)this.tickCount);
        tag.putFloat("ForcedYaw", ((Float)this.entityData.get(FORCED_YAW)).floatValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getShort("life");
        this.entityData.set(FORCED_YAW, (Object)Float.valueOf(tag.getFloat("ForcedYaw")));
    }

    public void tick() {
        int idleOpt = 100;
        this.idleTicks = this.getDeltaMovement().lengthSqr() < 0.01 ? ++this.idleTicks : 0;
        if (this.idleTicks < idleOpt) {
            super.tick();
        }
        ++this.ticksInAir;
        if (this.tickCount >= 190) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        boolean isInsideWaterBlock = this.level().isWaterAt(this.blockPosition());
        Helper.setOnFire((Entity)this);
        Helper.spawnLightSource((Entity)this, isInsideWaterBlock);
        if (this.level().isClientSide) {
            double x = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            double y = this.getY() + 0.05 + this.random.nextDouble();
            double z = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, true, x, y, z, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, true, x, y, z, 0.0, 0.0, 0.0);
        }
        if (this.getOwner() instanceof Player) {
            this.setYRot(((Float)this.entityData.get(FORCED_YAW)).floatValue());
        }
    }

    public boolean isNoGravity() {
        return !this.isUnderWater();
    }

    public void setSoundEvent(@NotNull SoundEvent soundIn) {
        this.getDefaultHitGroundSoundEvent();
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)SoundEvents.GENERIC_EXPLODE.value();
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            this.explode();
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.setSoundEvent((SoundEvent)SoundEvents.GENERIC_EXPLODE.value());
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        DamageSource damageSource2;
        Entity entity2;
        Entity entity = entityHitResult.getEntity();
        if (entityHitResult.getType() != HitResult.Type.ENTITY || !entityHitResult.getEntity().is(entity) && !this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if ((entity2 = this.getOwner()) == null) {
            damageSource2 = this.damageSources().arrow((AbstractArrow)this, (Entity)this);
        } else {
            damageSource2 = this.damageSources().arrow((AbstractArrow)this, entity2);
            if (entity2 instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity2;
                livingEntity.setLastHurtMob(entity);
            }
        }
        if (entity.hurt(damageSource2, CommonMod.config.gunconfigs.balrogconfigs.balrog_damage)) {
            if (entity instanceof LivingEntity) {
                Player player;
                livingEntity = (LivingEntity)entity;
                if (!this.level().isClientSide && entity2 instanceof LivingEntity && this.isOnFire()) {
                    livingEntity.setRemainingFireTicks(50);
                }
                this.explode();
                this.doPostHurtEffects(livingEntity);
                if (livingEntity != entity2 && livingEntity instanceof Player && (player = (Player)livingEntity) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (!this.isSilent()) {
                        serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
            }
        } else if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void explode() {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 1.0f, false, CommonMod.config.gunconfigs.balrog_breaks ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return Items.AIR.getDefaultInstance();
    }
}

