/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.projectiles;

import mod.azure.hwg.CommonMod;
import mod.azure.hwg.util.BlockBreakProgressManager;
import mod.azure.hwg.util.Helper;
import mod.azure.hwg.util.registry.HWGProjectiles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class BulletEntity
extends AbstractArrow {
    public float bulletdamage;
    public static final EntityDataAccessor<Float> FORCED_YAW = SynchedEntityData.defineId(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public BulletEntity(EntityType<? extends BulletEntity> entityType, Level world) {
        super(entityType, world);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public BulletEntity(Level world, LivingEntity owner, Float damage) {
        super(HWGProjectiles.BULLETS.get(), world);
        this.setOwner((Entity)owner);
        this.bulletdamage = damage.floatValue();
    }

    public BulletEntity(Level world, ItemStack stack, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        this(world, stack, x, y, z, shotAtAngle);
        this.setOwner(entity);
    }

    public BulletEntity(Level world, ItemStack stack, double x, double y, double z, boolean shotAtAngle) {
        this(world, x, y, z, stack);
    }

    public BulletEntity(Level world, double x, double y, double z, ItemStack stack) {
        super(HWGProjectiles.BULLETS.get(), world);
        this.absMoveTo(x, y, z);
    }

    protected void doPostHurtEffects(@NotNull LivingEntity living) {
        super.doPostHurtEffects(living);
        if (CommonMod.config.gunconfigs.bullets_disable_iframes_on_players || !(living instanceof Player)) {
            living.invulnerableTime = 0;
            living.setDeltaMovement(0.0, 0.0, 0.0);
        }
    }

    public void tickDespawn() {
        if (this.tickCount >= 40) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("ForcedYaw", ((Float)this.entityData.get(FORCED_YAW)).floatValue());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(FORCED_YAW, (Object)Float.valueOf(tag.getFloat("ForcedYaw")));
    }

    public void tick() {
        super.tick();
        if (this.tickCount >= 190) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.level().isClientSide) {
            double x = this.getX() + this.random.nextDouble() * (double)this.getBbWidth() * 0.5;
            double z = this.getZ() + this.random.nextDouble() * (double)this.getBbWidth() * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, true, x, this.getY(0.5), z, 0.0, 0.0, 0.0);
        }
        if (this.getOwner() instanceof Player) {
            this.setYRot(((Float)this.entityData.get(FORCED_YAW)).floatValue());
        }
        Helper.setOnFire((Entity)this);
    }

    public boolean isNoGravity() {
        return !this.isUnderWater();
    }

    public void setSoundEvent(@NotNull SoundEvent soundIn) {
        this.getDefaultHitGroundSoundEvent();
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value();
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (CommonMod.config.gunconfigs.bullets_breakdripstone && !this.level().getBlockState(blockHitResult.getBlockPos()).is(Blocks.BEDROCK)) {
            BlockBreakProgressManager.damage(this.level(), blockHitResult.getBlockPos(), this.bulletdamage * 2.0f);
        }
        if (this.level().getBlockState(blockHitResult.getBlockPos()).getBlock().defaultBlockState().is(Blocks.TNT)) {
            this.level().getBlockState(blockHitResult.getBlockPos()).setValue((Property)TntBlock.UNSTABLE, (Comparable)Boolean.valueOf(true));
        }
        if (this.level().getBlockState(blockHitResult.getBlockPos()).getBlock().defaultBlockState().is(Blocks.GLASS_PANE) || this.level().getBlockState(blockHitResult.getBlockPos()).getBlock() instanceof StainedGlassPaneBlock) {
            this.level().destroyBlock(blockHitResult.getBlockPos(), true);
        }
        this.setSoundEvent((SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value());
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        DamageSource damageSource2;
        Entity entity2;
        Entity entity = entityHitResult.getEntity();
        if (entityHitResult.getType() != HitResult.Type.ENTITY || !entityHitResult.getEntity().is(entity) && !this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if ((entity2 = this.getOwner()) == null) {
            damageSource2 = this.damageSources().arrow((AbstractArrow)this, (Entity)this);
        } else {
            damageSource2 = this.damageSources().arrow((AbstractArrow)this, entity2);
            if (entity2 instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity2;
                livingEntity.setLastHurtMob(entity);
            }
        }
        if (entity.hurt(damageSource2, this.bulletdamage)) {
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!this.level().isClientSide && entity2 instanceof LivingEntity && this.isOnFire()) {
                    livingEntity.setRemainingFireTicks(50);
                }
                this.doPostHurtEffects(livingEntity);
                if (livingEntity != entity2 && livingEntity instanceof Player && entity2 instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity2;
                    if (!this.isSilent()) {
                        serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
            }
        } else if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return Items.AIR.getDefaultInstance();
    }
}

