/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.projectiles;

import mod.azure.hwg.CommonMod;
import mod.azure.hwg.util.Helper;
import mod.azure.hwg.util.registry.HWGParticles;
import mod.azure.hwg.util.registry.HWGProjectiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class FireballEntity
extends AbstractArrow {
    public static final EntityDataAccessor<Float> FORCED_YAW = SynchedEntityData.defineId(FireballEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private int idleTicks = 0;

    public FireballEntity(EntityType<? extends FireballEntity> entityType, Level world) {
        super(entityType, world);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public FireballEntity(Level world, LivingEntity owner) {
        super(HWGProjectiles.FIREBALL.get(), world);
        this.setOwner((Entity)owner);
    }

    public boolean displayFireAnimation() {
        return true;
    }

    protected void doPostHurtEffects(@NotNull LivingEntity living) {
        super.doPostHurtEffects(living);
        if (CommonMod.config.gunconfigs.bullets_disable_iframes_on_players || !(living instanceof Player)) {
            living.invulnerableTime = 0;
            living.setDeltaMovement(0.0, 0.0, 0.0);
        }
    }

    public void tickDespawn() {
        if (this.tickCount >= 40) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("life", (short)this.tickCount);
        tag.putFloat("ForcedYaw", ((Float)this.entityData.get(FORCED_YAW)).floatValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getShort("life");
        this.entityData.set(FORCED_YAW, (Object)Float.valueOf(tag.getFloat("ForcedYaw")));
    }

    public void tick() {
        int idleOpt = 100;
        this.idleTicks = this.getDeltaMovement().lengthSqr() < 0.01 ? ++this.idleTicks : 0;
        if (this.idleTicks < idleOpt) {
            super.tick();
        }
        if (this.tickCount >= 190) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.getOwner() instanceof Player) {
            this.setYRot(((Float)this.entityData.get(FORCED_YAW)).floatValue());
        }
        boolean isInsideWaterBlock = this.level().isWaterAt(this.blockPosition());
        Helper.spawnLightSource((Entity)this, isInsideWaterBlock);
        if (this.level().isClientSide) {
            double x = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            double y = this.getY() + 0.05 + this.random.nextDouble();
            double z = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, true, x, y, z, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)HWGParticles.BRIM_ORANGE.get(), true, x, y, z, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)HWGParticles.BRIM_RED.get(), true, x, y, z, 0.0, 0.0, 0.0);
        }
        this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.0)).forEach(e -> {
            if (e.isAlive() && !(e instanceof Player) && !(this.getOwner() instanceof Player)) {
                e.setRemainingFireTicks(90);
            }
        });
    }

    public boolean isNoGravity() {
        return !this.isUnderWater();
    }

    public void setSoundEvent(@NotNull SoundEvent soundIn) {
        this.getDefaultHitGroundSoundEvent();
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.FIRE_AMBIENT;
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            Entity entity = this.getOwner();
            if (!(entity instanceof Mob) || this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                BlockPos blockPos = blockHitResult.getBlockPos().relative(blockHitResult.getDirection());
                if (this.level().isEmptyBlock(blockPos)) {
                    this.level().setBlockAndUpdate(blockPos, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockPos));
                }
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.setSoundEvent(SoundEvents.FIRE_AMBIENT);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        DamageSource damageSource2;
        Entity entity2;
        Entity entity = entityHitResult.getEntity();
        if (entityHitResult.getType() != HitResult.Type.ENTITY || !entityHitResult.getEntity().is(entity) && !this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if ((entity2 = this.getOwner()) == null) {
            damageSource2 = this.damageSources().arrow((AbstractArrow)this, (Entity)this);
        } else {
            damageSource2 = this.damageSources().arrow((AbstractArrow)this, entity2);
            if (entity2 instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity2;
                livingEntity.setLastHurtMob(entity);
            }
        }
        if (entity.hurt(damageSource2, CommonMod.config.gunconfigs.brimstoneconfigs.brimstone_damage)) {
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!this.level().isClientSide && entity2 instanceof LivingEntity && this.isOnFire()) {
                    livingEntity.setRemainingFireTicks(50);
                }
                this.doPostHurtEffects(livingEntity);
                if (livingEntity != entity2 && livingEntity instanceof Player && entity2 instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity2;
                    if (!this.isSilent()) {
                        serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
            }
        } else if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return Items.AIR.getDefaultInstance();
    }
}

