/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.projectiles;

import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.HWGEntity;
import mod.azure.hwg.util.Helper;
import mod.azure.hwg.util.registry.HWGParticles;
import mod.azure.hwg.util.registry.HWGProjectiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class FlameFiring
extends AbstractArrow {
    public static final EntityDataAccessor<Float> FORCED_YAW = SynchedEntityData.defineId(FlameFiring.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public SoundEvent hitSound = this.getDefaultHitGroundSoundEvent();
    private LivingEntity shooter;
    private int idleTicks = 0;

    public FlameFiring(EntityType<? extends FlameFiring> entityType, Level world) {
        super(entityType, world);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public FlameFiring(Level world, LivingEntity owner) {
        super(HWGProjectiles.FIRING.get(), world);
        this.shooter = owner;
    }

    public void tickDespawn() {
        if (this.tickCount >= 40) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected void doPostHurtEffects(@NotNull LivingEntity living) {
        super.doPostHurtEffects(living);
        if (CommonMod.config.gunconfigs.bullets_disable_iframes_on_players || !(living instanceof Player)) {
            living.setDeltaMovement(0.0, 0.0, 0.0);
            living.invulnerableTime = 0;
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("life", (short)this.tickCount);
        tag.putFloat("ForcedYaw", ((Float)this.entityData.get(FORCED_YAW)).floatValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getShort("life");
        this.entityData.set(FORCED_YAW, (Object)Float.valueOf(tag.getFloat("ForcedYaw")));
    }

    public void tick() {
        int idleOpt = 100;
        this.idleTicks = this.getDeltaMovement().lengthSqr() < 0.01 ? ++this.idleTicks : 0;
        if (this.idleTicks < idleOpt) {
            super.tick();
        }
        if (this.tickCount >= 190) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        boolean isInsideWaterBlock = this.level().isWaterAt(this.blockPosition());
        Helper.spawnLightSource((Entity)this, isInsideWaterBlock);
        if (this.getOwner() instanceof Player) {
            this.setYRot(((Float)this.entityData.get(FORCED_YAW)).floatValue());
        }
        if (this.tickCount % 16 == 2) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
        if (this.level().isClientSide) {
            double x = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            double y = this.getY() + 0.05 + this.random.nextDouble();
            double z = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, true, x, y, z, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)HWGParticles.BRIM_ORANGE.get(), true, x, y, z, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)HWGParticles.BRIM_RED.get(), true, x, y, z, 0.0, 0.0, 0.0);
        }
        this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.0)).forEach(e -> {
            if (e.isAlive() && !(e instanceof Player) && !(e instanceof HWGEntity)) {
                e.hurt(this.damageSources().arrow((AbstractArrow)this, (Entity)this.shooter), 3.0f);
                if (!(this.getOwner() instanceof Player)) {
                    e.setRemainingFireTicks(90);
                }
            }
        });
    }

    public boolean isNoGravity() {
        return !this.isUnderWater();
    }

    public void setSoundEvent(@NotNull SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.FIRE_AMBIENT;
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            BlockPos hitPos = blockHitResult.getBlockPos().above();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos firePos = hitPos.offset(x, 0, z);
                    if (!this.level().getBlockState(firePos).isAir()) continue;
                    this.level().setBlockAndUpdate(firePos, Blocks.FIRE.defaultBlockState());
                }
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.setSoundEvent(SoundEvents.FIRE_AMBIENT);
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public void setProperties(float pitch, float yaw, float roll, float modifierZ) {
        float f = (float)Math.PI / 180;
        float x = -Mth.sin((float)(yaw * f)) * Mth.cos((float)(pitch * f));
        float y = -Mth.sin((float)((pitch + roll) * f));
        float z = Mth.cos((float)(yaw * f)) * Mth.cos((float)(pitch * f));
        this.shoot(x, y, z, modifierZ, 0.0f);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return Items.AIR.getDefaultInstance();
    }
}

