/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.projectiles;

import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.TechnodemonEntity;
import mod.azure.hwg.entity.TechnodemonGreaterEntity;
import mod.azure.hwg.entity.projectiles.GrenadeDispatcher;
import mod.azure.hwg.util.registry.HWGProjectiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class GrenadeEntity
extends AbstractArrow {
    public static final EntityDataAccessor<Float> FORCED_YAW = SynchedEntityData.defineId(GrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(GrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(GrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public SoundEvent hitSound = this.getDefaultHitGroundSoundEvent();
    protected String type;
    public GrenadeDispatcher grenadeDispatcher;

    public GrenadeEntity(EntityType<? extends GrenadeEntity> entityType, Level world) {
        super(entityType, world);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        this.grenadeDispatcher = new GrenadeDispatcher((Entity)this);
    }

    public GrenadeEntity(Level world, LivingEntity owner) {
        super(HWGProjectiles.GRENADE.get(), world);
    }

    public GrenadeEntity(Level world, ItemStack stack, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        this(world, stack, x, y, z, shotAtAngle);
        this.setOwner(entity);
    }

    public GrenadeEntity(Level world, ItemStack stack, double x, double y, double z, boolean shotAtAngle) {
        this(world, x, y, z, stack);
    }

    public GrenadeEntity(Level world, double x, double y, double z, ItemStack stack) {
        super(HWGProjectiles.GRENADE.get(), world);
        this.absMoveTo(x, y, z);
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FORCED_YAW, (Object)Float.valueOf(0.0f));
        builder.define(VARIANT, (Object)0);
        builder.define(STATE, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("life", (short)this.tickCount);
        tag.putInt("Variant", this.getVariant());
        tag.putInt("State", this.getVariant());
        tag.putFloat("ForcedYaw", ((Float)this.entityData.get(FORCED_YAW)).floatValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getShort("life");
        this.setVariant(tag.getInt("Variant"));
        this.setVariant(tag.getInt("State"));
        this.entityData.set(FORCED_YAW, (Object)Float.valueOf(tag.getFloat("ForcedYaw")));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if ((Integer)this.entityData.get(STATE) == 1) {
                this.grenadeDispatcher.sendSpinAnimation();
            } else {
                this.grenadeDispatcher.sendBulletAnimation();
            }
        }
        if (this.getOwner() instanceof Player) {
            this.setYRot(((Float)this.entityData.get(FORCED_YAW)).floatValue());
        }
    }

    public int getVariant() {
        return Mth.clamp((int)((Integer)this.entityData.get(VARIANT)), (int)1, (int)5);
    }

    public void setVariant(int color) {
        this.entityData.set(VARIANT, (Object)color);
    }

    public void setState(int color) {
        this.entityData.set(STATE, (Object)color);
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        if (this.getVariant() == 1) {
            areaeffectcloudentity.setParticle(this.getParticle());
        }
        areaeffectcloudentity.setRadius(this.getVariant() == 4 ? 5.0f : 2.0f);
        areaeffectcloudentity.setDuration(this.getVariant() == 4 ? 120 : 2);
        if (this.getVariant() == 4) {
            areaeffectcloudentity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 1));
        }
        areaeffectcloudentity.absMoveTo(this.getX(), this.getEyeY(), this.getZ());
        this.level().addFreshEntity((Entity)areaeffectcloudentity);
        super.remove(reason);
    }

    private ParticleOptions getParticle() {
        return switch (this.getVariant()) {
            case 1, 2, 3 -> ParticleTypes.EXPLOSION;
            case 4 -> ParticleTypes.LARGE_SMOKE;
            case 5 -> ParticleTypes.FLASH;
            default -> ParticleTypes.END_ROD;
        };
    }

    protected void doPostHurtEffects(@NotNull LivingEntity target) {
        if (this.getVariant() == 1) {
            if (target instanceof TechnodemonEntity || target instanceof TechnodemonGreaterEntity) {
                super.doPostHurtEffects(target);
            } else {
                super.doPostHurtEffects(target);
            }
        }
    }

    public void tickDespawn() {
        if (this.tickCount >= 80) {
            if (this.getVariant() == 1) {
                this.emp();
            } else if (this.getVariant() == 2) {
                this.frag();
            } else if (this.getVariant() == 3) {
                this.naplam();
            } else if (this.getVariant() == 5) {
                this.stun();
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void setSoundEvent(@NotNull SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)SoundEvents.GENERIC_EXPLODE.value();
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            if (this.getVariant() == 1) {
                this.emp();
            } else if (this.getVariant() == 2) {
                this.frag();
            } else if (this.getVariant() == 3) {
                this.naplam();
            } else if (this.getVariant() == 5) {
                this.stun();
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.setSoundEvent((SoundEvent)SoundEvents.GENERIC_EXPLODE.value());
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (!this.level().isClientSide) {
            if (this.getVariant() == 1) {
                this.emp();
            } else if (this.getVariant() == 2) {
                this.frag();
            } else if (this.getVariant() == 3) {
                this.naplam();
            } else if (this.getVariant() == 5) {
                this.stun();
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void stun() {
        this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.0)).forEach(e -> {
            if (e.isAlive()) {
                e.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 1));
                e.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 200, 1));
            }
        });
    }

    protected void frag() {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 2.0f, false, CommonMod.config.gunconfigs.grenades_breaks ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
    }

    protected void naplam() {
        this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.0)).forEach(e -> {
            if (e.isAlive()) {
                e.setRemainingFireTicks(200);
            }
        });
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 1.0f, true, Level.ExplosionInteraction.NONE);
    }

    protected void emp() {
        this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(8.0)).forEach(e -> {
            if (e.isAlive() && (e instanceof TechnodemonEntity || e instanceof TechnodemonGreaterEntity)) {
                e.hurt(this.damageSources().arrow((AbstractArrow)this, (Entity)this), 10.0f);
            }
        });
        this.level().getBlockStatesIfLoaded(this.getBoundingBox().inflate(8.0)).filter(state -> state.is(Blocks.LEVER)).forEach(state -> {
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)this.blockPosition().offset(new Vec3i(-8, -8, -8)), (BlockPos)this.blockPosition().offset(new Vec3i(8, 8, 8)))) {
                if (!this.level().getBlockState(testPos).is(Blocks.LEVER)) continue;
                this.level().setBlockAndUpdate(testPos, (BlockState)state.setValue((Property)LeverBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        });
        this.level().getBlockStatesIfLoaded(this.getBoundingBox().inflate(8.0)).filter(state -> state.is(Blocks.REDSTONE_WIRE)).forEach(state -> {
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)this.blockPosition().offset(new Vec3i(-8, -8, -8)), (BlockPos)this.blockPosition().offset(new Vec3i(8, 8, 8)))) {
                if (!this.level().getBlockState(testPos).is(Blocks.REDSTONE_WIRE)) continue;
                this.level().setBlockAndUpdate(testPos, (BlockState)state.setValue((Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0)));
            }
        });
        this.level().getBlockStatesIfLoaded(this.getBoundingBox().inflate(8.0)).filter(state -> state.is(Blocks.COMPARATOR)).forEach(state -> {
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)this.blockPosition().offset(new Vec3i(-8, -8, -8)), (BlockPos)this.blockPosition().offset(new Vec3i(8, 8, 8)))) {
                if (!this.level().getBlockState(testPos).is(Blocks.COMPARATOR)) continue;
                this.level().setBlockAndUpdate(testPos, (BlockState)state.setValue((Property)DiodeBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        });
        this.level().getBlockStatesIfLoaded(this.getBoundingBox().inflate(8.0)).filter(state -> state.is(Blocks.REPEATER)).forEach(state -> {
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)this.blockPosition().offset(new Vec3i(-8, -8, -8)), (BlockPos)this.blockPosition().offset(new Vec3i(8, 8, 8)))) {
                if (!this.level().getBlockState(testPos).is(Blocks.REPEATER)) continue;
                this.level().setBlockAndUpdate(testPos, (BlockState)state.setValue((Property)DiodeBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        });
        this.level().getBlockStatesIfLoaded(this.getBoundingBox().inflate(8.0)).filter(state -> state.is(Blocks.REDSTONE_TORCH)).forEach(state -> {
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)this.blockPosition().offset(new Vec3i(-8, -8, -8)), (BlockPos)this.blockPosition().offset(new Vec3i(8, 8, 8)))) {
                if (!this.level().getBlockState(testPos).is(Blocks.REDSTONE_TORCH)) continue;
                this.level().destroyBlock(testPos, true, null, 512);
            }
        });
        this.level().getBlockStatesIfLoaded(this.getBoundingBox().inflate(8.0)).filter(state -> state.is(Blocks.REDSTONE_WALL_TORCH)).forEach(state -> {
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)this.blockPosition().offset(new Vec3i(-8, -8, -8)), (BlockPos)this.blockPosition().offset(new Vec3i(8, 8, 8)))) {
                if (!this.level().getBlockState(testPos).is(Blocks.REDSTONE_WALL_TORCH)) continue;
                this.level().destroyBlock(testPos, true, null, 512);
            }
        });
        this.level().getBlockStatesIfLoaded(this.getBoundingBox().inflate(8.0)).filter(state -> state.is(Blocks.REDSTONE_LAMP)).forEach(state -> {
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)this.blockPosition().offset(new Vec3i(-8, -8, -8)), (BlockPos)this.blockPosition().offset(new Vec3i(8, 8, 8)))) {
                if (!this.level().getBlockState(testPos).is(Blocks.REDSTONE_LAMP)) continue;
                this.level().setBlockAndUpdate(testPos, (BlockState)state.setValue((Property)RedstoneTorchBlock.LIT, (Comparable)Boolean.valueOf(false)));
            }
        });
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return Items.AIR.getDefaultInstance();
    }
}

