/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.projectiles;

import mod.azure.hwg.CommonMod;
import mod.azure.hwg.util.Helper;
import mod.azure.hwg.util.registry.HWGProjectiles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class MBulletEntity
extends AbstractArrow {
    public static final EntityDataAccessor<Float> FORCED_YAW = SynchedEntityData.defineId(MBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public SoundEvent hitSound = this.getDefaultHitGroundSoundEvent();

    public MBulletEntity(EntityType<? extends MBulletEntity> entityType, Level world) {
        super(entityType, world);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public MBulletEntity(Level world, LivingEntity owner) {
        super(HWGProjectiles.MBULLETS.get(), world);
    }

    public MBulletEntity(Level world, ItemStack stack, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        this(world, stack, x, y, z, shotAtAngle);
        this.setOwner(entity);
    }

    public MBulletEntity(Level world, ItemStack stack, double x, double y, double z, boolean shotAtAngle) {
        this(world, x, y, z, stack);
    }

    public MBulletEntity(Level world, double x, double y, double z, ItemStack stack) {
        super(HWGProjectiles.MBULLETS.get(), world);
        this.absMoveTo(x, y, z);
    }

    protected void doPostHurtEffects(@NotNull LivingEntity living) {
        super.doPostHurtEffects(living);
        living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 45, 1));
        living.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 45, 1));
        if (CommonMod.config.gunconfigs.bullets_disable_iframes_on_players || !(living instanceof Player)) {
            living.setDeltaMovement(0.0, 0.0, 0.0);
            living.invulnerableTime = 0;
        }
    }

    public void tickDespawn() {
        if (this.tickCount >= 40) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("life", (short)this.tickCount);
        tag.putFloat("ForcedYaw", ((Float)this.entityData.get(FORCED_YAW)).floatValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getShort("life");
        super.readAdditionalSaveData(tag);
        this.entityData.set(FORCED_YAW, (Object)Float.valueOf(tag.getFloat("ForcedYaw")));
    }

    public void tick() {
        super.tick();
        Helper.setOnFire((Entity)this);
        if (this.tickCount >= 190) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.level().isClientSide) {
            double d2 = this.getX() + this.random.nextDouble() * (double)this.getBbWidth() * 0.5;
            double f2 = this.getZ() + this.random.nextDouble() * (double)this.getBbWidth() * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, true, d2, this.getY(0.5), f2, 0.0, 0.0, 0.0);
        }
        if (this.getOwner() instanceof Player) {
            this.setYRot(((Float)this.entityData.get(FORCED_YAW)).floatValue());
        }
    }

    public boolean isNoGravity() {
        return !this.isUnderWater();
    }

    public void setSoundEvent(@NotNull SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value();
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.level().getBlockState(blockHitResult.getBlockPos()).getBlock() instanceof PointedDripstoneBlock && CommonMod.config.gunconfigs.bullets_breakdripstone) {
            this.level().destroyBlock(blockHitResult.getBlockPos(), true);
        }
        if (this.level().getBlockState(blockHitResult.getBlockPos()).getBlock().defaultBlockState().is(Blocks.GLASS_PANE) || this.level().getBlockState(blockHitResult.getBlockPos()).getBlock() instanceof StainedGlassPaneBlock) {
            this.level().destroyBlock(blockHitResult.getBlockPos(), true);
        }
        this.setSoundEvent((SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value());
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        DamageSource damageSource2;
        Entity entity2;
        Entity entity = entityHitResult.getEntity();
        if (entityHitResult.getType() != HitResult.Type.ENTITY || !entityHitResult.getEntity().is(entity) && !this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if ((entity2 = this.getOwner()) == null) {
            damageSource2 = this.damageSources().arrow((AbstractArrow)this, (Entity)this);
        } else {
            damageSource2 = this.damageSources().arrow((AbstractArrow)this, entity2);
            if (entity2 instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity2;
                livingEntity.setLastHurtMob(entity);
            }
        }
        if (entity.hurt(damageSource2, CommonMod.config.gunconfigs.meanieconfigs.meanie_damage)) {
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!this.level().isClientSide && entity2 instanceof LivingEntity && this.isOnFire()) {
                    livingEntity.setRemainingFireTicks(50);
                }
                this.doPostHurtEffects(livingEntity);
                if (livingEntity != entity2 && livingEntity instanceof Player && entity2 instanceof ServerPlayer && !this.isSilent()) {
                    ((ServerPlayer)entity2).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
            }
        } else if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return Items.AIR.getDefaultInstance();
    }
}

