/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.projectiles;

import mod.azure.hwg.CommonMod;
import mod.azure.hwg.util.Helper;
import mod.azure.hwg.util.registry.HWGProjectiles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RocketEntity
extends AbstractArrow {
    public static final EntityDataAccessor<Float> FORCED_YAW = SynchedEntityData.defineId(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public SoundEvent hitSound = this.getDefaultHitGroundSoundEvent();

    public RocketEntity(EntityType<? extends RocketEntity> entityType, Level world) {
        super(entityType, world);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public RocketEntity(Level world, LivingEntity owner) {
        super(HWGProjectiles.ROCKETS.get(), world);
    }

    public void tickDespawn() {
        if (this.tickCount >= 80) {
            this.explode();
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("life", (short)this.tickCount);
        tag.putFloat("ForcedYaw", ((Float)this.entityData.get(FORCED_YAW)).floatValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getShort("life");
        super.readAdditionalSaveData(tag);
        this.entityData.set(FORCED_YAW, (Object)Float.valueOf(tag.getFloat("ForcedYaw")));
    }

    public void tick() {
        super.tick();
        Helper.setOnFire((Entity)this);
        if (this.level().isClientSide) {
            double x = this.getX() + this.random.nextDouble() * (double)this.getBbWidth() * 0.5;
            double z = this.getZ() + this.random.nextDouble() * (double)this.getBbWidth() * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, true, x, this.getY(0.5), z, 0.0, 0.0, 0.0);
        }
        boolean bl = this.isNoPhysics();
        Vec3 vec3d = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double f = vec3d.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)vec3d.x, (double)vec3d.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)vec3d.y, (double)f) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        if (this.getOwner() instanceof Player) {
            this.setYRot(((Float)this.entityData.get(FORCED_YAW)).floatValue());
        }
        if (this.tickCount >= 190) {
            this.explode();
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.tickCount > 80 && !bl) {
            this.tickDespawn();
        } else {
            this.tickCount = 0;
            Vec3 vec3d3 = this.position();
            Vec3 vector3d3 = vec3d3.add(vec3d);
            BlockHitResult hitResult = this.level().clip(new ClipContext(vec3d3, vector3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitResult.getType() != HitResult.Type.MISS) {
                vector3d3 = hitResult.getLocation();
            }
            while (!this.isRemoved()) {
                EntityHitResult entityHitResult = this.findHitEntity(vec3d3, vector3d3);
                if (entityHitResult != null) {
                    hitResult = entityHitResult;
                }
                if (hitResult != null && hitResult.getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitResult).getEntity();
                    Entity entity2 = this.getOwner();
                    if (entity instanceof Player) {
                        Player player1;
                        Player player = (Player)entity;
                        if (entity2 instanceof Player && !(player1 = (Player)entity2).canHarmPlayer(player)) {
                            hitResult = null;
                            entityHitResult = null;
                        }
                    }
                }
                if (hitResult != null && !bl) {
                    this.onHit((HitResult)hitResult);
                    this.hasImpulse = true;
                }
                if (entityHitResult == null || this.getPierceLevel() <= 0) break;
                hitResult = null;
            }
            vec3d = this.getDeltaMovement();
            double d = vec3d.x;
            double e = vec3d.y;
            double g = vec3d.z;
            double h = this.getX() + d;
            double j = this.getY() + e;
            double k = this.getZ() + g;
            double l = vec3d.horizontalDistance();
            if (bl) {
                this.setYRot((float)(Mth.atan2((double)(-e), (double)(-g)) * 57.2957763671875));
            } else {
                this.setYRot((float)(Mth.atan2((double)e, (double)g) * 57.2957763671875));
            }
            this.setXRot((float)(Mth.atan2((double)e, (double)l) * 57.2957763671875));
            this.setXRot(RocketEntity.lerpRotation((float)this.xRotO, (float)this.getXRot()));
            this.setYRot(RocketEntity.lerpRotation((float)this.yRotO, (float)this.getYRot()));
            float m = 0.99f;
            this.setDeltaMovement(vec3d.scale((double)m));
            if (!this.isNoGravity() && !bl) {
                this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y - (double)0.05f, this.getDeltaMovement().z);
            }
            this.absMoveTo(h, j, k);
            this.checkInsideBlocks();
        }
    }

    public boolean isNoGravity() {
        return !this.isUnderWater();
    }

    public void setSoundEvent(@NotNull SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)SoundEvents.GENERIC_EXPLODE.value();
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            this.explode();
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.setSoundEvent((SoundEvent)SoundEvents.GENERIC_EXPLODE.value());
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (!this.level().isClientSide) {
            this.explode();
            if (this.isOnFire() && entityHitResult.getEntity() instanceof LivingEntity) {
                entityHitResult.getEntity().setRemainingFireTicks(50);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void explode() {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 2.0f, false, CommonMod.config.gunconfigs.rocket_breaks ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return Items.AIR.getDefaultInstance();
    }
}

