/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.projectiles;

import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.projectiles.BulletEntity;
import mod.azure.hwg.util.BlockBreakProgressManager;
import mod.azure.hwg.util.registry.HWGItems;
import mod.azure.hwg.util.registry.HWGProjectiles;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class SBulletEntity
extends BulletEntity {
    public SBulletEntity(EntityType<? extends BulletEntity> entityType, Level world) {
        super(entityType, world);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public SBulletEntity(Level world, LivingEntity owner, Float damage) {
        super(HWGProjectiles.SILVERBULLETS.get(), world);
        this.bulletdamage = damage.floatValue();
    }

    public SBulletEntity(Level world, ItemStack stack, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        this(world, stack, x, y, z, shotAtAngle);
        this.setOwner(entity);
    }

    public SBulletEntity(Level world, ItemStack stack, double x, double y, double z, boolean shotAtAngle) {
        this(world, x, y, z, stack);
    }

    public SBulletEntity(Level world, double x, double y, double z, ItemStack stack) {
        super(HWGProjectiles.SILVERBULLETS.get(), world);
        this.absMoveTo(x, y, z);
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        DamageSource damageSource2;
        Entity entity2;
        Entity entity = entityHitResult.getEntity();
        if (entityHitResult.getType() != HitResult.Type.ENTITY || !entityHitResult.getEntity().is(entity) && !this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if ((entity2 = this.getOwner()) == null) {
            damageSource2 = this.damageSources().indirectMagic((Entity)this, (Entity)this);
        } else {
            damageSource2 = this.damageSources().indirectMagic((Entity)this, entity2);
            if (entity2 instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity2;
                livingEntity.setLastHurtMob(entity);
            }
        }
        if (entity.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)CommonMod.modResource("vulnerable_to_silver")))) {
            if (entity.hurt(damageSource2, this.bulletdamage * 3.0f)) {
                if (entity instanceof LivingEntity) {
                    livingEntity = (LivingEntity)entity;
                    if (!this.level().isClientSide && entity2 instanceof LivingEntity && this.isOnFire()) {
                        livingEntity.setRemainingFireTicks(50);
                    }
                    this.doPostHurtEffects(livingEntity);
                    if (livingEntity != entity2 && livingEntity instanceof Player && entity2 instanceof ServerPlayer && !this.isSilent()) {
                        ((ServerPlayer)entity2).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
            } else if (!this.level().isClientSide) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else if (entity.hurt(damageSource2, this.bulletdamage)) {
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!this.level().isClientSide && entity2 instanceof LivingEntity && this.isOnFire()) {
                    livingEntity.setRemainingFireTicks(50);
                }
                this.doPostHurtEffects(livingEntity);
                if (entity2 != null && livingEntity != entity2 && livingEntity instanceof Player && entity2 instanceof ServerPlayer && !this.isSilent()) {
                    ((ServerPlayer)entity2).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
            }
        } else if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (CommonMod.config.gunconfigs.bullets_breakdripstone && !this.level().getBlockState(blockHitResult.getBlockPos()).is(Blocks.BEDROCK)) {
            BlockBreakProgressManager.damage(this.level(), blockHitResult.getBlockPos(), this.bulletdamage * 2.0f);
        }
        if (this.level().getBlockState(blockHitResult.getBlockPos()).getBlock().defaultBlockState().is(Blocks.TNT)) {
            this.level().getBlockState(blockHitResult.getBlockPos()).setValue((Property)TntBlock.UNSTABLE, (Comparable)Boolean.valueOf(true));
        }
        if (this.level().getBlockState(blockHitResult.getBlockPos()).getBlock().defaultBlockState().is(Blocks.GLASS_PANE) || this.level().getBlockState(blockHitResult.getBlockPos()).getBlock() instanceof StainedGlassPaneBlock) {
            this.level().destroyBlock(blockHitResult.getBlockPos(), true);
        }
        this.setSoundEvent((SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value());
    }

    @NotNull
    public ItemStack getPickupItem() {
        return new ItemStack((ItemLike)HWGItems.BULLETS.get());
    }
}

