/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.tasks;

import java.util.function.Consumer;
import mod.azure.azurelib.sblforked.api.core.behaviour.ExtendedBehaviour;
import mod.azure.hwg.entity.HWGEntity;
import mod.azure.hwg.util.registry.HWGItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;

public abstract class CustomDelayedBehaviour<E extends HWGEntity>
extends ExtendedBehaviour<E> {
    protected final int delayTime;
    protected long delayFinishedAt = 0L;
    protected Consumer<E> delayedCallback = entity -> {};

    protected CustomDelayedBehaviour(int delayTicks) {
        this.delayTime = delayTicks;
        this.runFor(entity -> Math.max(delayTicks, 60));
    }

    public final CustomDelayedBehaviour<E> whenActivating(Consumer<E> callback) {
        this.delayedCallback = callback;
        return this;
    }

    protected final void start(ServerLevel level, E entity, long gameTime) {
        if (this.delayTime > 0) {
            this.delayFinishedAt = gameTime + (long)this.delayTime;
            super.start(level, entity, gameTime);
        } else {
            super.start(level, entity, gameTime);
            this.doDelayedAction(entity);
        }
        if (entity.getTarget() != null) {
            if (!entity.getItemBySlot(EquipmentSlot.MAINHAND).is((Item)HWGItems.MINIGUN.get()) && !entity.isWithinMeleeAttackRange(entity.getTarget())) {
                ((HWGEntity)((Object)entity)).animationDispatcher.sendRangedAnimation();
            }
            entity.lookAt((Entity)entity.getTarget(), 30.0f, 30.0f);
        }
    }

    protected final void stop(ServerLevel level, E entity, long gameTime) {
        super.stop(level, entity, gameTime);
        this.delayFinishedAt = 0L;
    }

    protected boolean shouldKeepRunning(E entity) {
        return this.delayFinishedAt >= entity.level().getGameTime();
    }

    protected final void tick(ServerLevel level, E entity, long gameTime) {
        super.tick(level, entity, gameTime);
        if (this.delayFinishedAt <= gameTime) {
            this.doDelayedAction(entity);
            this.delayedCallback.accept(entity);
        }
    }

    protected void doDelayedAction(E entity) {
    }
}

