/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity.tasks;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import mod.azure.hwg.entity.HWGEntity;
import mod.azure.hwg.entity.tasks.CustomDelayedBehaviour;
import mod.azure.hwg.util.Helper;
import mod.azure.hwg.util.registry.HWGItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class RangedShootingAttack<E extends HWGEntity>
extends CustomDelayedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT)});
    protected ToIntFunction<E> attackIntervalSupplier = entity -> entity.getItemBySlot(EquipmentSlot.MAINHAND).is((Item)HWGItems.AK47.get()) || entity.getItemBySlot(EquipmentSlot.MAINHAND).is((Item)HWGItems.SMG.get()) || entity.getItemBySlot(EquipmentSlot.MAINHAND).is((Item)HWGItems.TOMMYGUN.get()) ? 1 : (entity.getItemBySlot(EquipmentSlot.MAINHAND).is((Item)HWGItems.FLAMETHROWER.get()) ? 3 : 20);
    @Nullable
    protected LivingEntity target = null;

    public RangedShootingAttack(int delayTicks) {
        super(delayTicks);
    }

    public RangedShootingAttack<E> attackInterval(ToIntFunction<E> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        this.target = BrainUtils.getTargetOfEntity(entity);
        if (!entity.getSensing().hasLineOfSight((Entity)this.target)) {
            return false;
        }
        assert (this.target != null);
        return this.target.isAlive() && !entity.isWithinMeleeAttackRange(this.target);
    }

    protected void start(E entity) {
        entity.swing(InteractionHand.MAIN_HAND);
        BehaviorUtils.lookAtEntity(entity, (LivingEntity)this.target);
    }

    protected void stop(E entity) {
        this.target = null;
    }

    @Override
    protected void doDelayedAction(E entity) {
        BrainUtils.setForgettableMemory(entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)this.attackIntervalSupplier.applyAsInt(entity));
        if (this.target == null) {
            return;
        }
        if (!entity.getSensing().hasLineOfSight((Entity)this.target) || entity.isWithinMeleeAttackRange(this.target)) {
            return;
        }
        entity.lookAt((Entity)this.target, 30.0f, 30.0f);
        if (entity.getItemBySlot(EquipmentSlot.MAINHAND).is((Item)HWGItems.MINIGUN.get())) {
            for (int j = 0; j < 3; ++j) {
                ((HWGEntity)((Object)entity)).shoot();
            }
        } else {
            ((HWGEntity)((Object)entity)).shoot();
        }
        boolean isInsideWaterBlock = entity.level().isWaterAt(entity.blockPosition());
        Helper.spawnLightSource(entity, isInsideWaterBlock);
    }
}

