/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.item.ammo;

import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.projectiles.GrenadeEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GrenadeSmokeItem
extends Item {
    public GrenadeSmokeItem() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        Player user;
        if (livingEntity instanceof Player && !(user = (Player)livingEntity).getCooldowns().isOnCooldown((Item)this)) {
            user.getCooldowns().addCooldown((Item)this, CommonMod.config.gunconfigs.grenades_throw_cooldown);
            if (!level.isClientSide) {
                GrenadeEntity nadeEntity = new GrenadeEntity(level, new ItemStack((ItemLike)Items.AIR), (Entity)user, user.getX(), user.getEyeY() - (double)0.15f, user.getZ(), true);
                nadeEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
                nadeEntity.setVariant(4);
                nadeEntity.setState(1);
                level.addFreshEntity((Entity)nadeEntity);
            }
            if (!user.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }
}

