/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.item.weapons;

import commonnetwork.api.Network;
import io.netty.buffer.Unpooled;
import java.util.List;
import mod.azure.azurelib.common.api.client.helper.ClientUtils;
import mod.azure.azurelib.common.internal.common.AzureLibMod;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.entity.projectiles.BlazeRodEntity;
import mod.azure.hwg.entity.projectiles.BulletEntity;
import mod.azure.hwg.entity.projectiles.FireballEntity;
import mod.azure.hwg.entity.projectiles.FlameFiring;
import mod.azure.hwg.entity.projectiles.MBulletEntity;
import mod.azure.hwg.entity.projectiles.RocketEntity;
import mod.azure.hwg.entity.projectiles.SBulletEntity;
import mod.azure.hwg.entity.projectiles.ShellEntity;
import mod.azure.hwg.item.enums.GunTypeEnum;
import mod.azure.hwg.item.enums.ProjectileEnum;
import mod.azure.hwg.item.weapons.animations.GunDispatcher;
import mod.azure.hwg.network.FiringPacket;
import mod.azure.hwg.network.ReloadPacket;
import mod.azure.hwg.util.Helper;
import mod.azure.hwg.util.registry.HWGItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class AzureAnimatedGunItem
extends Item {
    protected Item ammoType;
    protected final String id;
    protected final SoundEvent firingSound;
    protected final SoundEvent reloadSound;
    protected final GunTypeEnum gunTypeEnum;
    public static final String firing = "firing";
    private static final String controller = "controller";
    protected final ProjectileEnum projectileTypeEnum;
    private GunDispatcher animationDispatcher;

    public AzureAnimatedGunItem(String id, ProjectileEnum projectileTypeEnum, GunTypeEnum gunTypeEnum, int maxClipSize, SoundEvent reloadSound, SoundEvent firingSound) {
        super(new Item.Properties().stacksTo(1).durability(maxClipSize + 1));
        this.id = id;
        this.projectileTypeEnum = projectileTypeEnum;
        this.gunTypeEnum = gunTypeEnum;
        this.reloadSound = reloadSound;
        this.firingSound = firingSound;
        this.animationDispatcher = new GunDispatcher();
    }

    public String getItemID() {
        return this.id;
    }

    public ProjectileEnum getProjectileTypeEnum() {
        return this.projectileTypeEnum;
    }

    public GunTypeEnum getGunTypeEnum() {
        return this.gunTypeEnum;
    }

    public Item getAmmoType() {
        switch (this.getProjectileTypeEnum()) {
            case BULLET: 
            case HELL: {
                this.ammoType = HWGItems.BULLETS.get();
                break;
            }
            case BLAZE: {
                this.ammoType = Items.BLAZE_ROD;
                break;
            }
            case MEANIE: {
                this.ammoType = Items.REDSTONE;
                break;
            }
            case SHELL: {
                this.ammoType = HWGItems.SHOTGUN_SHELL.get();
                break;
            }
            case ROCKET: {
                this.ammoType = HWGItems.ROCKET.get();
                break;
            }
            case FLAMES: 
            case FIREBALL: {
                this.ammoType = (Item)HWGItems.FUEL_TANK.get();
                break;
            }
            case SILVER_BULLET: {
                this.ammoType = HWGItems.SILVERBULLET.get();
            }
        }
        return this.ammoType;
    }

    public SoundEvent getReloadSound() {
        return this.reloadSound;
    }

    public SoundEvent getFiringSound() {
        return this.firingSound;
    }

    public int getReloadAmount() {
        if (this.gunTypeEnum == GunTypeEnum.FLAMETHROWER) {
            return CommonMod.config.gunconfigs.flammerconfigs.flammer_cap;
        }
        if (this.gunTypeEnum == GunTypeEnum.BRIMSTONE) {
            return CommonMod.config.gunconfigs.brimstoneconfigs.brimstone_cap;
        }
        return 1;
    }

    public int getCoolDown() {
        switch (this.gunTypeEnum) {
            case FLAMETHROWER: {
                return CommonMod.config.gunconfigs.flammerconfigs.flammer_cooldown;
            }
            case SMG: {
                return CommonMod.config.gunconfigs.smgconfigs.smg_cooldown;
            }
            case AK7: {
                return CommonMod.config.gunconfigs.ak47configs.ak47_cooldown;
            }
            case TOMMYGUN: {
                return CommonMod.config.gunconfigs.tommyconfigs.tommy_cooldown;
            }
            case MINIGUN: {
                return CommonMod.config.gunconfigs.minigunconfigs.minigun_cooldown;
            }
            case GOLDEN_PISTOL: {
                return CommonMod.config.gunconfigs.gpistolconfigs.golden_pistol_cooldown;
            }
            case BALROG: {
                return CommonMod.config.gunconfigs.balrogconfigs.balrog_cooldown;
            }
            case BRIMSTONE: {
                return CommonMod.config.gunconfigs.brimstoneconfigs.brimstone_cooldown;
            }
            case HELLHORSE: 
            case SILVER_HELL: {
                return CommonMod.config.gunconfigs.hellhorseconfigs.hellhorse_cooldown;
            }
            case LUGER: {
                return CommonMod.config.gunconfigs.lugerconfigs.luger_cooldown;
            }
            case MEANIE: {
                return CommonMod.config.gunconfigs.meanieconfigs.meanie_cooldown;
            }
            case PISTOL: 
            case SILVER_PISTOL: {
                return CommonMod.config.gunconfigs.pistolconfigs.pistol_cooldown;
            }
            case SIL_PISTOL: {
                return CommonMod.config.gunconfigs.silencedpistolconfigs.silenced_pistol_cooldown;
            }
            case ROCKETLAUNCHER: {
                return CommonMod.config.gunconfigs.rocketlauncherconfigs.rocketlauncherCooldown;
            }
            case SHOTGUN: {
                return CommonMod.config.gunconfigs.shotgunconfigs.shotgun_cooldown;
            }
            case SNIPER: {
                return CommonMod.config.gunconfigs.sniperconfigs.sniper_cooldown;
            }
        }
        return 10;
    }

    public int getReloadCoolDown() {
        switch (this.gunTypeEnum) {
            case FLAMETHROWER: {
                return CommonMod.config.gunconfigs.flammerconfigs.flammerReloadCooldown;
            }
            case SMG: {
                return CommonMod.config.gunconfigs.smgconfigs.smgReloadCooldown;
            }
            case AK7: {
                return CommonMod.config.gunconfigs.ak47configs.ak47ReloadCooldown;
            }
            case TOMMYGUN: {
                return CommonMod.config.gunconfigs.tommyconfigs.tommyReloadCooldown;
            }
            case MINIGUN: {
                return CommonMod.config.gunconfigs.minigunconfigs.minigunReloadCooldown;
            }
            case GOLDEN_PISTOL: {
                return CommonMod.config.gunconfigs.gpistolconfigs.goldenPistolReloadCooldown;
            }
            case BALROG: {
                return CommonMod.config.gunconfigs.balrogconfigs.balrogReloadCooldown;
            }
            case BRIMSTONE: {
                return CommonMod.config.gunconfigs.brimstoneconfigs.brimstoneReloadCooldown;
            }
            case HELLHORSE: 
            case SILVER_HELL: {
                return CommonMod.config.gunconfigs.hellhorseconfigs.hellhorseReloadCooldown;
            }
            case LUGER: {
                return CommonMod.config.gunconfigs.lugerconfigs.lugerReloadCooldown;
            }
            case MEANIE: {
                return CommonMod.config.gunconfigs.meanieconfigs.meanieReloadCooldown;
            }
            case PISTOL: 
            case SILVER_PISTOL: {
                return CommonMod.config.gunconfigs.pistolconfigs.pistolReloadCooldown;
            }
            case SIL_PISTOL: {
                return CommonMod.config.gunconfigs.silencedpistolconfigs.silencedPistolReloadCooldown;
            }
            case ROCKETLAUNCHER: {
                return CommonMod.config.gunconfigs.rocketlauncherconfigs.rocketlauncherReloadCooldown;
            }
            case SHOTGUN: {
                return CommonMod.config.gunconfigs.shotgunconfigs.shotgunReloadCooldown;
            }
            case SNIPER: {
                return CommonMod.config.gunconfigs.sniperconfigs.sniperReloadCooldown;
            }
        }
        return 10;
    }

    public float getAttackDamage() {
        switch (this.gunTypeEnum) {
            case FLAMETHROWER: 
            case BALROG: 
            case ROCKETLAUNCHER: {
                return 0.0f;
            }
            case SMG: {
                return CommonMod.config.gunconfigs.smgconfigs.smg_damage;
            }
            case AK7: {
                return CommonMod.config.gunconfigs.ak47configs.ak47_damage;
            }
            case TOMMYGUN: {
                return CommonMod.config.gunconfigs.tommyconfigs.tommy_damage;
            }
            case MINIGUN: {
                return CommonMod.config.gunconfigs.minigunconfigs.minigun_damage;
            }
            case GOLDEN_PISTOL: {
                return CommonMod.config.gunconfigs.gpistolconfigs.golden_pistol_damage;
            }
            case BRIMSTONE: {
                return CommonMod.config.gunconfigs.brimstoneconfigs.brimstone_damage;
            }
            case HELLHORSE: 
            case SILVER_HELL: {
                return CommonMod.config.gunconfigs.hellhorseconfigs.hellhorse_damage;
            }
            case LUGER: {
                return CommonMod.config.gunconfigs.lugerconfigs.luger_damage;
            }
            case MEANIE: {
                return CommonMod.config.gunconfigs.meanieconfigs.meanie_damage;
            }
            case PISTOL: 
            case SILVER_PISTOL: {
                return CommonMod.config.gunconfigs.pistolconfigs.pistol_damage;
            }
            case SIL_PISTOL: {
                return CommonMod.config.gunconfigs.silencedpistolconfigs.silenced_pistol_damage;
            }
            case SHOTGUN: {
                return CommonMod.config.gunconfigs.shotgunconfigs.shotgun_damage;
            }
            case SNIPER: {
                return CommonMod.config.gunconfigs.sniperconfigs.sniper_damage;
            }
        }
        return 0.0f;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    private void singleFire(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Player player) {
        EntityHitResult result = Helper.hitscanTrace(player, 64.0, 1.0f);
        player.getCooldowns().addCooldown((Item)this, this.getCoolDown());
        switch (this.getProjectileTypeEnum()) {
            case BULLET: {
                BulletEntity bullet = Helper.createBullet(level, (LivingEntity)player, this.getAttackDamage());
                bullet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 20.0f, 1.0f);
                bullet.tickCount = -15;
                level.addFreshEntity((Entity)bullet);
                break;
            }
            case HELL: {
                BulletEntity bullet = Helper.createBullet(level, (LivingEntity)player, this.getAttackDamage());
                bullet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 60.0f, 1.0f);
                bullet.tickCount = -15;
                level.addFreshEntity((Entity)bullet);
                break;
            }
            case BLAZE: {
                BlazeRodEntity rod = Helper.createBlazeRod(level, (LivingEntity)player);
                rod.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f, 1.0f);
                rod.moveTo(player.getX(), player.getY(0.85), player.getZ(), 0.0f, 0.0f);
                rod.isNoGravity();
                rod.isOnFire();
                BlazeRodEntity rod1 = Helper.createBlazeRod(level, (LivingEntity)player);
                rod1.shootFromRotation((Entity)player, player.getXRot() + 2.0f, player.getYRot(), 0.0f, 3.0f, 1.0f);
                rod1.moveTo(player.getX(), player.getY(0.85), player.getZ(), 0.0f, 0.0f);
                rod1.isNoGravity();
                rod1.isOnFire();
                BlazeRodEntity rod2 = Helper.createBlazeRod(level, (LivingEntity)player);
                rod2.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + 2.0f, 0.0f, 3.0f, 1.0f);
                rod2.moveTo(player.getX(), player.getY(0.85), player.getZ(), 0.0f, 0.0f);
                rod2.isNoGravity();
                rod2.isOnFire();
                BlazeRodEntity rod3 = Helper.createBlazeRod(level, (LivingEntity)player);
                rod3.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() - 2.0f, 0.0f, 3.0f, 1.0f);
                rod3.moveTo(player.getX(), player.getY(0.85), player.getZ(), 0.0f, 0.0f);
                rod3.isNoGravity();
                rod3.isOnFire();
                level.addFreshEntity((Entity)rod);
                level.addFreshEntity((Entity)rod1);
                level.addFreshEntity((Entity)rod2);
                level.addFreshEntity((Entity)rod3);
                break;
            }
            case FIREBALL: {
                FireballEntity fireball = Helper.createFireball(level, (LivingEntity)player);
                fireball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.75f, 1.0f);
                fireball.moveTo(player.getX(), player.getY(0.5), player.getZ(), 0.0f, 0.0f);
                fireball.setRemainingFireTicks(100);
                FireballEntity fireball1 = Helper.createFireball(level, (LivingEntity)player);
                fireball1.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + 5.0f, 0.0f, 0.75f, 1.0f);
                fireball1.moveTo(player.getX(), player.getY(0.5), player.getZ(), 0.0f, 0.0f);
                fireball1.setRemainingFireTicks(100);
                FireballEntity fireball2 = Helper.createFireball(level, (LivingEntity)player);
                fireball2.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() - 5.0f, 0.0f, 0.75f, 1.0f);
                fireball2.moveTo(player.getX(), player.getY(0.5), player.getZ(), 0.0f, 0.0f);
                fireball2.setRemainingFireTicks(100);
                level.addFreshEntity((Entity)fireball);
                level.addFreshEntity((Entity)fireball1);
                level.addFreshEntity((Entity)fireball2);
                break;
            }
            case MEANIE: {
                MBulletEntity bullet = Helper.createMeanieBullet(level, (LivingEntity)player);
                bullet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 60.0f, 1.0f);
                bullet.tickCount = -15;
                level.addFreshEntity((Entity)bullet);
                break;
            }
            case SHELL: {
                ShellEntity bullet = Helper.createShell(level, (LivingEntity)player);
                bullet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + 1.0f, 0.5f, 20.0f, 1.0f);
                ShellEntity bullet1 = Helper.createShell(level, (LivingEntity)player);
                bullet1.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() - 1.0f, 0.5f, 20.0f, 1.0f);
                bullet.tickCount = -15;
                bullet1.tickCount = -15;
                level.addFreshEntity((Entity)bullet);
                level.addFreshEntity((Entity)bullet1);
                break;
            }
            case ROCKET: {
                RocketEntity rocket = Helper.createRocket(level, (LivingEntity)player);
                rocket.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                rocket.moveTo(player.getX(), player.getY(0.5), player.getZ(), 0.0f, 0.0f);
                rocket.setBaseDamage(2.5);
                level.addFreshEntity((Entity)rocket);
                break;
            }
            case SILVER_BULLET: {
                SBulletEntity bullet = Helper.createSilverBullet(level, (LivingEntity)player);
                bullet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 20.0f, 1.0f);
                bullet.tickCount = -15;
                level.addFreshEntity((Entity)bullet);
                break;
            }
            case FLAMES: {
                FlameFiring flames = Helper.createFlame(level, (LivingEntity)player);
                flames.setProperties(player.getXRot(), player.getYRot(), 0.0f, 1.5f);
                flames.getEntityData().set(FlameFiring.FORCED_YAW, (Object)Float.valueOf(player.getYRot()));
                double d = player.getX();
                double d2 = d + (switch (player.getDirection()) {
                    case Direction.WEST -> -0.5;
                    case Direction.EAST -> 0.5;
                    default -> 0.0;
                });
                double d3 = player.getY();
                double d4 = d3 + (switch (player.getDirection()) {
                    case Direction.DOWN -> 0.5;
                    case Direction.UP -> (double)-1.85f;
                    default -> 0.75;
                });
                double d5 = player.getZ();
                flames.moveTo(d2, d4, d5 + (switch (player.getDirection()) {
                    case Direction.NORTH -> -0.5;
                    case Direction.SOUTH -> 0.5;
                    default -> 0.0;
                }), 0.0f, 0.0f);
                level.addFreshEntity((Entity)flames);
            }
        }
    }

    public void fireWeapon(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Player player) {
        Item item = itemStack.getItem();
        if (item instanceof AzureAnimatedGunItem) {
            AzureAnimatedGunItem gunItem = (AzureAnimatedGunItem)item;
            if (!player.getCooldowns().isOnCooldown((Item)gunItem)) {
                Helper.spawnLightSource((Entity)player, player.level().isWaterAt(player.blockPosition()));
                itemStack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(itemStack));
                if (this.getFiringSound() != null) {
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), this.getFiringSound(), SoundSource.PLAYERS, 0.25f, 1.3f);
                }
                if (!level.isClientSide) {
                    this.singleFire(itemStack, level, player);
                    gunItem.animationDispatcher.sendFiringCommand((Entity)player, itemStack);
                }
            }
        }
    }

    public void autoFire(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Player player) {
        Item item = itemStack.getItem();
        if (item instanceof AzureAnimatedGunItem) {
            AzureAnimatedGunItem gunItem = (AzureAnimatedGunItem)item;
            if (!player.getCooldowns().isOnCooldown((Item)gunItem)) {
                Helper.spawnLightSource((Entity)player, player.level().isWaterAt(player.blockPosition()));
                itemStack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(itemStack));
                if (this.getFiringSound() != null) {
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), this.getFiringSound(), SoundSource.PLAYERS, 0.25f, 1.3f);
                }
                if (!level.isClientSide) {
                    if (this.getProjectileTypeEnum() == ProjectileEnum.BULLET) {
                        BulletEntity bullet = Helper.createBullet(level, (LivingEntity)player, this.getAttackDamage());
                        bullet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 20.0f, 1.0f);
                        bullet.tickCount = -15;
                        level.addFreshEntity((Entity)bullet);
                    }
                    gunItem.animationDispatcher.sendFiringCommand((Entity)player, itemStack);
                }
            }
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, Level world, @NotNull Entity entity, int slot, boolean selected) {
        Player player;
        if (world.isClientSide && entity instanceof Player && (player = (Player)entity).getItemInHand(player.getUsedItemHand()).getItem() instanceof AzureAnimatedGunItem && selected) {
            FriendlyByteBuf passedData;
            if (ClientUtils.RELOAD.consumeClick()) {
                passedData = new FriendlyByteBuf(Unpooled.buffer());
                passedData.writeBoolean(true);
                Network.getNetworkHandler().sendToServer((Object)new ReloadPacket());
            }
            if (AzureLibMod.config.useVanillaUseKey) {
                if (Minecraft.getInstance().options.keyUse.isDown()) {
                    passedData = new FriendlyByteBuf(Unpooled.buffer());
                    passedData.writeBoolean(true);
                    Network.getNetworkHandler().sendToServer((Object)new FiringPacket());
                }
            } else if (ClientUtils.FIRE_WEAPON.isDown()) {
                passedData = new FriendlyByteBuf(Unpooled.buffer());
                passedData.writeBoolean(true);
                Network.getNetworkHandler().sendToServer((Object)new FiringPacket());
            }
            if (this.gunTypeEnum == GunTypeEnum.BRIMSTONE || this.gunTypeEnum == GunTypeEnum.BALROG) {
                this.animationDispatcher.sendIdleCommand(entity, stack);
            }
        }
    }

    public static void shoot(Player player) {
        Item item;
        if (player.getItemInHand(player.getUsedItemHand()).getDamageValue() < player.getItemInHand(player.getUsedItemHand()).getMaxDamage() - 1 && (item = player.getItemInHand(player.getUsedItemHand()).getItem()) instanceof AzureAnimatedGunItem) {
            AzureAnimatedGunItem gunBase = (AzureAnimatedGunItem)item;
            if (!player.getCooldowns().isOnCooldown(player.getItemInHand(player.getUsedItemHand()).getItem()) && !player.getItemInHand(player.getUsedItemHand()).is((Item)HWGItems.MINIGUN.get())) {
                gunBase.fireWeapon(player.getItemInHand(player.getUsedItemHand()), player.level(), player);
            } else {
                gunBase.autoFire(player.getItemInHand(player.getUsedItemHand()), player.level(), player);
            }
        } else {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.COMPARATOR_CLICK, SoundSource.PLAYERS, 0.25f, 1.3f);
        }
    }

    public static void reload(Player user, InteractionHand hand) {
        Item item = user.getItemInHand(user.getUsedItemHand()).getItem();
        if (item instanceof AzureAnimatedGunItem) {
            AzureAnimatedGunItem gunBase = (AzureAnimatedGunItem)item;
            while (!user.isCreative() && user.getItemInHand(user.getUsedItemHand()).getDamageValue() != 0 && user.getInventory().countItem(gunBase.getAmmoType()) > 0) {
                Helper.removeAmmo(gunBase.getAmmoType(), user);
                user.getCooldowns().addCooldown((Item)gunBase, gunBase.getReloadCoolDown());
                user.getItemInHand(user.getUsedItemHand()).hurtAndBreak(-gunBase.getReloadAmount(), (LivingEntity)user, user.getEquipmentSlotForItem(user.getItemInHand(user.getUsedItemHand())));
                user.getItemInHand(user.getUsedItemHand()).setPopTime(3);
                if (gunBase.getReloadSound() != null) {
                    user.level().playSound(null, user.getX(), user.getY(), user.getZ(), gunBase.getReloadSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (user.level().isClientSide) continue;
                if (user.getRandom().nextInt(0, 100) >= 95 && gunBase.getItemID().equalsIgnoreCase("tommy_gun")) {
                    gunBase.animationDispatcher.sendTommyReloadCommand((Entity)user, user.getItemInHand(hand));
                    continue;
                }
                gunBase.animationDispatcher.sendReloadCommand((Entity)user, user.getItemInHand(hand));
            }
        }
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity livingEntity) {
        return 72000;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        tooltip.add((Component)Component.translatable((String)("Fuel: " + (stack.getMaxDamage() - stack.getDamageValue() - 1) + " / " + (stack.getMaxDamage() - 1))).withStyle(ChatFormatting.ITALIC));
        switch (this.getProjectileTypeEnum()) {
            case BULLET: 
            case HELL: {
                tooltip.add((Component)Component.translatable((String)"hwg.ammo.reloadbullets").withStyle(ChatFormatting.ITALIC));
                break;
            }
            case BLAZE: {
                tooltip.add((Component)Component.translatable((String)"hwg.ammo.reloadblazerod").withStyle(ChatFormatting.ITALIC));
                break;
            }
            case FLAMES: 
            case FIREBALL: {
                tooltip.add((Component)Component.translatable((String)"hwg.ammo.reloadfuel").withStyle(ChatFormatting.ITALIC));
                tooltip.add((Component)Component.translatable((String)("Fuel: " + (stack.getMaxDamage() - stack.getDamageValue() - 1) + " / " + (stack.getMaxDamage() - 1))).withStyle(ChatFormatting.ITALIC));
                break;
            }
            case MEANIE: {
                tooltip.add((Component)Component.translatable((String)"hwg.ammo.reloadredstone").withStyle(ChatFormatting.ITALIC));
                break;
            }
            case SHELL: {
                tooltip.add((Component)Component.translatable((String)"hwg.ammo.reloadshells").withStyle(ChatFormatting.ITALIC));
                break;
            }
            case ROCKET: {
                tooltip.add((Component)Component.translatable((String)"hwg.ammo.reloadrockets").withStyle(ChatFormatting.ITALIC));
                break;
            }
            case SILVER_BULLET: {
                tooltip.add((Component)Component.translatable((String)"hwg.ammo.reloadsilverbullets").withStyle(ChatFormatting.ITALIC));
            }
        }
    }
}

