/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.item.weapons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mod.azure.hwg.entity.projectiles.BaseFlareEntity;
import mod.azure.hwg.item.weapons.HWGGunLoadedBase;
import mod.azure.hwg.item.weapons.animations.GunDispatcher;
import mod.azure.hwg.util.registry.HWGItems;
import mod.azure.hwg.util.registry.HWGSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FlareGunItem
extends HWGGunLoadedBase {
    private GunDispatcher animationDispatcher = new GunDispatcher();
    private boolean loaded = false;
    private boolean charged = false;
    private static final Predicate<ItemStack> BLACK_FLARE = stack -> stack.getItem() == HWGItems.BLACK_FLARE;
    public static final Predicate<ItemStack> FLARE = BLACK_FLARE.or(stack -> stack.getItem() == HWGItems.BLUE_FLARE).or(stack -> stack.getItem() == HWGItems.BROWN_FLARE).or(stack -> stack.getItem() == HWGItems.CYAN_FLARE).or(stack -> stack.getItem() == HWGItems.GRAY_FLARE).or(stack -> stack.getItem() == HWGItems.GREEN_FLARE).or(stack -> stack.getItem() == HWGItems.LIGHTBLUE_FLARE).or(stack -> stack.getItem() == HWGItems.LIGHTGRAY_FLARE).or(stack -> stack.getItem() == HWGItems.LIME_FLARE).or(stack -> stack.getItem() == HWGItems.MAGENTA_FLARE).or(stack -> stack.getItem() == HWGItems.ORANGE_FLARE).or(stack -> stack.getItem() == HWGItems.PINK_FLARE).or(stack -> stack.getItem() == HWGItems.PURPLE_FLARE).or(stack -> stack.getItem() == HWGItems.RED_FLARE).or(stack -> stack.getItem() == HWGItems.WHITE_FLARE).or(stack -> stack.getItem() == HWGItems.YELLOW_FLARE);

    public FlareGunItem() {
        super(new Item.Properties().stacksTo(1).durability(31).component(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY));
    }

    private void shootFlare(Level level, LivingEntity shooter, InteractionHand hand, ItemStack stack, List<ItemStack> projectile, boolean creative, float speed, float divergence) {
        float i = 1.0f;
        for (ItemStack itemStack : projectile) {
            boolean yellow;
            if (itemStack.isEmpty()) continue;
            i = -i;
            if (!creative) {
                stack.hurtAndBreak(this.getDurabilityUse(itemStack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            BaseFlareEntity flareEntity = new BaseFlareEntity(level, (Entity)shooter, shooter.getX(), shooter.getEyeY() - (double)0.15f, shooter.getZ(), true);
            boolean black = itemStack.getItem() == HWGItems.BLACK_FLARE;
            boolean blue = itemStack.getItem() == HWGItems.BLUE_FLARE;
            boolean brown = itemStack.getItem() == HWGItems.BROWN_FLARE;
            boolean cyan = itemStack.getItem() == HWGItems.CYAN_FLARE;
            boolean gray = itemStack.getItem() == HWGItems.GRAY_FLARE;
            boolean green = itemStack.getItem() == HWGItems.GREEN_FLARE;
            boolean lightBlue = itemStack.getItem() == HWGItems.LIGHTBLUE_FLARE;
            boolean lightGray = itemStack.getItem() == HWGItems.LIGHTGRAY_FLARE;
            boolean lime = itemStack.getItem() == HWGItems.LIME_FLARE;
            boolean magenta = itemStack.getItem() == HWGItems.MAGENTA_FLARE;
            boolean orange = itemStack.getItem() == HWGItems.ORANGE_FLARE;
            boolean pink = itemStack.getItem() == HWGItems.PINK_FLARE;
            boolean purple = itemStack.getItem() == HWGItems.PURPLE_FLARE;
            boolean red = itemStack.getItem() == HWGItems.RED_FLARE;
            boolean bl = yellow = itemStack.getItem() == HWGItems.YELLOW_FLARE;
            if (black) {
                flareEntity.setColor(1);
            } else if (blue) {
                flareEntity.setColor(2);
            } else if (brown) {
                flareEntity.setColor(3);
            } else if (cyan) {
                flareEntity.setColor(4);
            } else if (gray) {
                flareEntity.setColor(5);
            } else if (green) {
                flareEntity.setColor(6);
            } else if (lightBlue) {
                flareEntity.setColor(7);
            } else if (lightGray) {
                flareEntity.setColor(8);
            } else if (lime) {
                flareEntity.setColor(9);
            } else if (magenta) {
                flareEntity.setColor(10);
            } else if (orange) {
                flareEntity.setColor(11);
            } else if (pink) {
                flareEntity.setColor(12);
            } else if (purple) {
                flareEntity.setColor(13);
            } else if (red) {
                flareEntity.setColor(14);
            } else if (yellow) {
                flareEntity.setColor(15);
            } else {
                flareEntity.setColor(16);
            }
            Vec3 vec3d = shooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0, vec3d.x, vec3d.y, vec3d.z);
            Vec3 vec3d2 = shooter.getViewVector(1.0f);
            Vector3f vector3f = vec3d2.toVector3f().rotate((Quaternionfc)quaternionf);
            vector3f.rotate((Quaternionfc)quaternionf);
            flareEntity.shoot(vector3f.x, vector3f.y, vector3f.z, speed, divergence);
            flareEntity.setBaseDamage(0.3);
            flareEntity.pickup = AbstractArrow.Pickup.DISALLOWED;
            if (!creative) {
                stack.hurtAndBreak(1, shooter, shooter.getEquipmentSlotForItem(shooter.getUseItem()));
            }
            level.addFreshEntity((Entity)flareEntity);
        }
    }

    private static boolean tryLoadProjectiles(LivingEntity shooter, ItemStack crossbowStack) {
        List list = FlareGunItem.draw((ItemStack)crossbowStack, (ItemStack)shooter.getProjectile(crossbowStack), (LivingEntity)shooter);
        if (!list.isEmpty()) {
            crossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((List)list));
            return true;
        }
        return false;
    }

    public static boolean isCharged(ItemStack stack) {
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        return !chargedProjectiles.isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public void shootAll(Level level, LivingEntity entity, InteractionHand hand, ItemStack stack, float speed, float divergence) {
        block2: {
            if (level.isClientSide() || (chargedProjectiles = (ChargedProjectiles)stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY)) == null || chargedProjectiles.isEmpty()) break block2;
            if (!(entity instanceof Player)) ** GOTO lbl-1000
            player = (Player)entity;
            if (player.getAbilities().instabuild) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            bl = v0;
            this.shootFlare(level, entity, hand, stack, chargedProjectiles.getItems(), bl, speed, divergence);
        }
    }

    public static int getPullTime() {
        return 25;
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack ingredient) {
        return Tiers.IRON.getRepairIngredient().test(ingredient) || super.isValidRepairItem(stack, ingredient);
    }

    @NotNull
    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return FLARE;
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return FLARE;
    }

    public int getDefaultProjectileRange() {
        return 16;
    }

    protected void shootProjectile(@NotNull LivingEntity shooter, @NotNull Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)itemStack.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedProjectiles != null && !chargedProjectiles.isEmpty()) {
            this.shootAll(level, (LivingEntity)player, usedHand, itemStack, 2.6f, 1.0f);
            player.getCooldowns().addCooldown((Item)this, 25);
            if (!level.isClientSide) {
                this.animationDispatcher.sendFiringCommand((Entity)player, itemStack);
            }
            return InteractionResultHolder.consume((Object)itemStack);
        }
        if (!player.getProjectile(itemStack).isEmpty()) {
            player.startUsingItem(usedHand);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int remainingUseTicks) {
        if (!FlareGunItem.isCharged(stack) && FlareGunItem.tryLoadProjectiles(livingEntity, stack)) {
            SoundSource soundCategory = livingEntity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), HWGSounds.GLAUNCHERRELOAD.get(), soundCategory, 0.5f, 1.0f);
            if (!level.isClientSide && stack.getItem() instanceof FlareGunItem) {
                this.animationDispatcher.sendLoadingCommand((Entity)livingEntity, stack);
            }
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.getCooldowns().addCooldown((Item)this, 15);
            }
        }
    }

    public void onUseTick(Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        if (!world.isClientSide) {
            float f = (float)(stack.getUseDuration(user) - remainingUseTicks) / (float)FlareGunItem.getPullTime();
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
            }
            if (f >= 0.5f && !this.loaded) {
                this.loaded = true;
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedProjectiles != null && !chargedProjectiles.isEmpty()) {
            ItemStack itemStack = (ItemStack)chargedProjectiles.getItems().getFirst();
            tooltipComponents.add((Component)Component.literal((String)"Ammo").append(CommonComponents.SPACE).append(itemStack.getDisplayName()));
            if (tooltipFlag.isAdvanced() && itemStack.getItem() == FLARE) {
                ArrayList list = Lists.newArrayList();
                HWGItems.FLARE_GUN.get().appendHoverText(itemStack, context, list, tooltipFlag);
                if (!list.isEmpty()) {
                    list.replaceAll(component -> Component.literal((String)"  ").append(component).withStyle(ChatFormatting.GRAY));
                    tooltipComponents.addAll(list);
                }
            }
        }
        tooltipComponents.add((Component)Component.translatable((String)"hwg.ammo.reloadflares").withStyle(ChatFormatting.ITALIC));
    }
}

