/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.item.weapons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mod.azure.hwg.entity.projectiles.GrenadeEntity;
import mod.azure.hwg.item.weapons.HWGGunLoadedBase;
import mod.azure.hwg.item.weapons.animations.GunDispatcher;
import mod.azure.hwg.util.Helper;
import mod.azure.hwg.util.registry.HWGItems;
import mod.azure.hwg.util.registry.HWGSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GrenadeLauncherItem
extends HWGGunLoadedBase {
    public static final Predicate<ItemStack> EMP = stack -> stack.getItem() == HWGItems.G_EMP;
    public static final Predicate<ItemStack> GRENADES = EMP.or(stack -> stack.getItem() == HWGItems.G_FRAG).or(stack -> stack.getItem() == HWGItems.G_NAPALM).or(stack -> stack.getItem() == HWGItems.G_SMOKE).or(stack -> stack.getItem() == HWGItems.G_STUN);
    private GunDispatcher animationDispatcher = new GunDispatcher();
    private boolean charged = false;
    private boolean loaded = false;

    public GrenadeLauncherItem() {
        super(new Item.Properties().stacksTo(1).durability(31).component(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY));
    }

    @NotNull
    private static GrenadeEntity getGrenadeEntity(Level world, LivingEntity shooter, ItemStack projectile) {
        boolean emp = projectile.getItem() == HWGItems.G_EMP;
        boolean frag = projectile.getItem() == HWGItems.G_FRAG;
        boolean napalm = projectile.getItem() == HWGItems.G_NAPALM;
        boolean stun = projectile.getItem() == HWGItems.G_STUN;
        GrenadeEntity nade = new GrenadeEntity(world, projectile, (Entity)shooter, shooter.getX(), shooter.getEyeY() - (double)0.15f, shooter.getZ(), true);
        nade.setState(0);
        if (emp) {
            nade.setVariant(1);
        } else if (frag) {
            nade.setVariant(2);
        } else if (napalm) {
            nade.setVariant(3);
        } else if (stun) {
            nade.setVariant(5);
        } else {
            nade.setVariant(4);
        }
        return nade;
    }

    private static boolean tryLoadProjectiles(LivingEntity shooter, ItemStack crossbowStack) {
        List list = GrenadeLauncherItem.draw((ItemStack)crossbowStack, (ItemStack)shooter.getProjectile(crossbowStack), (LivingEntity)shooter);
        if (!list.isEmpty()) {
            crossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((List)list));
            return true;
        }
        return false;
    }

    public static boolean isCharged(ItemStack stack) {
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        return !chargedProjectiles.isEmpty();
    }

    public static int getPullTime() {
        return 20;
    }

    /*
     * Unable to fully structure code
     */
    public void shootAll(Level level, LivingEntity entity, InteractionHand hand, ItemStack stack, float speed, float divergence) {
        block2: {
            if (level.isClientSide() || (chargedProjectiles = (ChargedProjectiles)stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY)) == null || chargedProjectiles.isEmpty()) break block2;
            if (!(entity instanceof Player)) ** GOTO lbl-1000
            player = (Player)entity;
            if (player.getAbilities().instabuild) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            bl = v0;
            this.shootNade(level, entity, hand, stack, chargedProjectiles.getItems(), bl, speed, divergence);
        }
    }

    private void shootNade(Level level, LivingEntity shooter, InteractionHand hand, ItemStack stack, List<ItemStack> projectile, boolean creative, float speed, float divergence) {
        float i = 1.0f;
        for (ItemStack itemStack : projectile) {
            if (itemStack.isEmpty()) continue;
            i = -i;
            if (!creative) {
                stack.hurtAndBreak(this.getDurabilityUse(itemStack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            GrenadeEntity nade = GrenadeLauncherItem.getGrenadeEntity(level, shooter, itemStack);
            Vec3 vec3d = shooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0, vec3d.x, vec3d.y, vec3d.z);
            Vec3 vec3d2 = shooter.getViewVector(1.0f);
            Vector3f vector3f = vec3d2.toVector3f().rotate((Quaternionfc)quaternionf);
            vector3f.rotate((Quaternionfc)quaternionf);
            nade.shoot(vector3f.x, vector3f.y, vector3f.z, speed, divergence);
            level.addFreshEntity((Entity)nade);
            level.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), HWGSounds.GLAUNCHERFIRE.get(), SoundSource.PLAYERS, 1.0f, 0.9f);
        }
    }

    @NotNull
    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return GRENADES;
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return GRENADES;
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack ingredient) {
        return Tiers.IRON.getRepairIngredient().test(ingredient) || super.isValidRepairItem(stack, ingredient);
    }

    public int getDefaultProjectileRange() {
        return 16;
    }

    protected void shootProjectile(@NotNull LivingEntity shooter, @NotNull Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)itemStack.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedProjectiles != null && !chargedProjectiles.isEmpty()) {
            this.shootAll(level, (LivingEntity)player, usedHand, itemStack, 2.6f, 1.0f);
            player.getCooldowns().addCooldown((Item)this, 25);
            boolean isInsideWaterBlock = player.level().isWaterAt(player.blockPosition());
            Helper.spawnLightSource((Entity)player, isInsideWaterBlock);
            if (!level.isClientSide) {
                this.animationDispatcher.sendFiringCommand((Entity)player, itemStack);
            }
            return InteractionResultHolder.consume((Object)itemStack);
        }
        if (!player.getProjectile(itemStack).isEmpty()) {
            player.startUsingItem(usedHand);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int remainingUseTicks) {
        if (!GrenadeLauncherItem.isCharged(stack) && GrenadeLauncherItem.tryLoadProjectiles(livingEntity, stack)) {
            SoundSource soundCategory = livingEntity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), HWGSounds.GLAUNCHERRELOAD.get(), soundCategory, 0.5f, 1.0f);
            if (!level.isClientSide) {
                this.animationDispatcher.sendLoadingCommand((Entity)livingEntity, stack);
            }
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.getCooldowns().addCooldown((Item)this, 15);
            }
        }
    }

    public void onUseTick(Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        if (!world.isClientSide) {
            float f = (float)(stack.getUseDuration(user) - remainingUseTicks) / (float)GrenadeLauncherItem.getPullTime();
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
            }
            if (f >= 0.5f && !this.loaded) {
                this.loaded = true;
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedProjectiles != null && !chargedProjectiles.isEmpty()) {
            ItemStack itemStack = (ItemStack)chargedProjectiles.getItems().getFirst();
            tooltipComponents.add((Component)Component.literal((String)"Ammo").append(CommonComponents.SPACE).append(itemStack.getDisplayName()));
            if (tooltipFlag.isAdvanced() && itemStack.getItem() == GRENADES) {
                ArrayList list = Lists.newArrayList();
                HWGItems.G_EMP.get().appendHoverText(itemStack, context, list, tooltipFlag);
                if (!list.isEmpty()) {
                    list.replaceAll(component -> Component.literal((String)"  ").append(component).withStyle(ChatFormatting.GRAY));
                    tooltipComponents.addAll(list);
                }
            }
        }
        tooltipComponents.add((Component)Component.translatable((String)"hwg.ammo.reloadgrenades").withStyle(ChatFormatting.ITALIC));
    }
}

